/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.hash;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import org.fisco.bcos.sdk.crypto.exceptions.HashException;
import org.fisco.bcos.sdk.crypto.hash.Hash;
import org.fisco.bcos.sdk.utils.Hex;

public class Keccak256
implements Hash {
    @Override
    public String hash(String inputData) {
        return this.calculateHash(inputData.getBytes());
    }

    @Override
    public byte[] hash(byte[] inputBytes) {
        return Hex.decode(this.calculateHash(inputBytes));
    }

    @Override
    public String hashBytes(byte[] inputBytes) {
        return this.calculateHash(inputBytes);
    }

    private String calculateHash(byte[] inputBytes) {
        CryptoResult hashResult = NativeInterface.keccak256((String)Hex.toHexString(inputBytes));
        if (hashResult.wedprErrorMessage != null && !hashResult.wedprErrorMessage.isEmpty()) {
            throw new HashException("Calculate hash with keccak256 failed! error message:" + hashResult.wedprErrorMessage);
        }
        return hashResult.hash;
    }
}

