/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.keypair;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.sdk.crypto.hash.Hash;
import org.fisco.bcos.sdk.crypto.hash.Keccak256;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;

public class ECDSAKeyPair
extends CryptoKeyPair {
    public static Hash DefaultHashAlgorithm = new Keccak256();

    public ECDSAKeyPair() {
        this.initECDSAKeyPair();
        CryptoKeyPair keyPair = this.generateKeyPair();
        this.hexPrivateKey = keyPair.getHexPrivateKey();
        this.hexPublicKey = keyPair.getHexPublicKey();
    }

    public ECDSAKeyPair(KeyPair javaKeyPair) {
        super(javaKeyPair);
        this.initECDSAKeyPair();
    }

    protected ECDSAKeyPair(CryptoResult ecKeyPairInfo) {
        super(ecKeyPairInfo);
        this.initECDSAKeyPair();
    }

    private void initECDSAKeyPair() {
        this.hashImpl = new Keccak256();
        this.curveName = "secp256k1";
        this.keyStoreSubDir = "ecdsa";
        this.signatureAlgorithm = "SHA256WITHECDSA";
    }

    public static CryptoKeyPair createKeyPair() {
        return new ECDSAKeyPair(NativeInterface.secp256k1keyPair());
    }

    @Override
    public CryptoKeyPair generateKeyPair() {
        return new ECDSAKeyPair(NativeInterface.secp256k1keyPair());
    }

    @Override
    public CryptoKeyPair createKeyPair(KeyPair javaKeyPair) {
        return new ECDSAKeyPair(javaKeyPair);
    }

    public static String getAddressByPublicKey(String publicKey) {
        return ECDSAKeyPair.getAddress(publicKey, DefaultHashAlgorithm);
    }

    public static byte[] getAddressByPublicKey(byte[] publicKey) {
        return Hex.decode(Numeric.cleanHexPrefix(ECDSAKeyPair.getAddressByPublicKey(Hex.toHexString(publicKey))));
    }

    public static byte[] getAddressByPublicKey(BigInteger publicKey) {
        byte[] publicKeyBytes = Numeric.toBytesPadded(publicKey, 64);
        return ECDSAKeyPair.getAddressByPublicKey(publicKeyBytes);
    }
}

