/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.keypair;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.sdk.crypto.hash.Hash;
import org.fisco.bcos.sdk.crypto.hash.SM3Hash;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;

public class SM2KeyPair
extends CryptoKeyPair {
    public static Hash DefaultHashAlgorithm = new SM3Hash();

    public SM2KeyPair() {
        this.initSM2KeyPairObject();
        CryptoKeyPair keyPair = this.generateKeyPair();
        this.hexPrivateKey = keyPair.getHexPrivateKey();
        this.hexPublicKey = keyPair.getHexPublicKey();
    }

    public SM2KeyPair(KeyPair javaKeyPair) {
        super(javaKeyPair);
        this.initSM2KeyPairObject();
    }

    protected SM2KeyPair(CryptoResult sm2keyPairInfo) {
        super(sm2keyPairInfo);
        this.initSM2KeyPairObject();
    }

    private void initSM2KeyPairObject() {
        this.keyStoreSubDir = "gm";
        this.hashImpl = new SM3Hash();
        this.curveName = "sm2p256v1";
        this.signatureAlgorithm = "1.2.156.10197.1.501";
    }

    public static CryptoKeyPair createKeyPair() {
        return new SM2KeyPair(NativeInterface.sm2keyPair());
    }

    @Override
    public CryptoKeyPair generateKeyPair() {
        return new SM2KeyPair(NativeInterface.sm2keyPair());
    }

    @Override
    public CryptoKeyPair createKeyPair(KeyPair javaKeyPair) {
        return new SM2KeyPair(javaKeyPair);
    }

    public static String getAddressByPublicKey(String publicKey) {
        return SM2KeyPair.getAddress(publicKey, DefaultHashAlgorithm);
    }

    public static byte[] getAddressByPublicKey(byte[] publicKey) {
        return Hex.decode(Numeric.cleanHexPrefix(SM2KeyPair.getAddressByPublicKey(Hex.toHexString(publicKey))));
    }

    public static byte[] getAddressByPublicKey(BigInteger publicKey) {
        byte[] publicKeyBytes = Numeric.toBytesPadded(publicKey, 64);
        return SM2KeyPair.getAddressByPublicKey(publicKeyBytes);
    }
}

