/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.signature;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import org.fisco.bcos.sdk.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.signature.SM2SignatureResult;
import org.fisco.bcos.sdk.crypto.signature.Signature;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;

public class SM2Signature
implements Signature {
    @Override
    public SignatureResult sign(String message, CryptoKeyPair keyPair) {
        return new SM2SignatureResult(keyPair.getHexPublicKey(), this.signWithStringSignature(message, keyPair));
    }

    @Override
    public SignatureResult sign(byte[] message, CryptoKeyPair keyPair) {
        return this.sign(Hex.toHexString(message), keyPair);
    }

    @Override
    public String signWithStringSignature(String message, CryptoKeyPair keyPair) {
        CryptoResult signatureResult = NativeInterface.sm2SignWithPub((String)keyPair.getHexPrivateKey(), (String)keyPair.getHexPublicKey(), (String)Numeric.cleanHexPrefix(message));
        if (signatureResult.wedprErrorMessage != null && !signatureResult.wedprErrorMessage.isEmpty()) {
            throw new SignatureException("Sign with sm2 failed:" + signatureResult.wedprErrorMessage);
        }
        return signatureResult.signature;
    }

    @Override
    public boolean verify(String publicKey, String message, String signature) {
        String hexPubKeyWithPrefix = Numeric.getHexKeyWithPrefix(publicKey, "04", 128);
        CryptoResult verifyResult = NativeInterface.sm2verify((String)hexPubKeyWithPrefix, (String)Numeric.cleanHexPrefix(message), (String)signature);
        if (verifyResult.wedprErrorMessage != null && !verifyResult.wedprErrorMessage.isEmpty()) {
            throw new SignatureException("Verify with sm2 failed:" + verifyResult.wedprErrorMessage);
        }
        return verifyResult.result;
    }

    @Override
    public boolean verify(String publicKey, byte[] message, byte[] signature) {
        return this.verify(publicKey, Hex.toHexString(message), Hex.toHexString(signature));
    }
}

