/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.signature;

import java.util.ArrayList;
import java.util.List;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.rlp.RlpString;
import org.fisco.bcos.sdk.rlp.RlpType;
import org.fisco.bcos.sdk.utils.Hex;

public class SM2SignatureResult
extends SignatureResult {
    protected byte[] pub;

    public SM2SignatureResult(String hexPublicKey, String signatureString) {
        super(signatureString);
        this.pub = Hex.decode(hexPublicKey.substring(2));
    }

    public SM2SignatureResult(byte[] pub, byte[] r, byte[] s) {
        super(r, s);
        this.pub = pub;
    }

    @Override
    public String convertToString() {
        byte[] SignatureBytes = new byte[64];
        System.arraycopy(this.r, 0, SignatureBytes, 0, 32);
        System.arraycopy(this.s, 0, SignatureBytes, 32, 32);
        return Hex.toHexString(SignatureBytes);
    }

    @Override
    public List<RlpType> encode() {
        ArrayList<RlpType> encodeResult = new ArrayList<RlpType>();
        encodeResult.add(RlpString.create(this.pub));
        super.encodeCommonField(encodeResult);
        return encodeResult;
    }

    public byte[] getPub() {
        return this.pub;
    }

    public void setPub(byte[] pub) {
        this.pub = pub;
    }
}

