/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.eventsub;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import org.fisco.bcos.sdk.model.Message;

public class EventMsg
extends Message {
    private static final long serialVersionUID = -7276897518418560354L;
    private String topic;

    public EventMsg() {
    }

    public EventMsg(Message msg) {
        this.length = msg.getLength();
        this.type = msg.getType();
        this.seq = msg.getSeq();
        this.result = msg.getResult();
    }

    @Override
    public void encode(ByteBuf encodedData) {
        this.writeHeader(encodedData);
        this.writeExtra(encodedData);
    }

    @Override
    public void writeHeader(ByteBuf out) {
        try {
            this.length = 43 + this.topic.getBytes("utf-8").length + this.data.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(" topic string to utf8 failed, topic: " + this.topic);
        }
        super.writeHeader(out);
    }

    public void writeExtra(ByteBuf out) {
        try {
            out.writeByte(1 + this.topic.getBytes("utf-8").length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(" topic string to utf8 failed, topic: " + this.topic);
        }
        out.writeBytes(this.topic.getBytes());
        out.writeBytes(this.data);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String toTopic) {
        this.topic = toTopic;
    }
}

