/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.eventsub.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.ChannelHandlerContext;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.sdk.eventsub.EventCallback;
import org.fisco.bcos.sdk.eventsub.EventLogParams;
import org.fisco.bcos.sdk.eventsub.EventSubscribe;
import org.fisco.bcos.sdk.eventsub.filter.EventLogFilterStatus;
import org.fisco.bcos.sdk.model.EventLog;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;

public class EventLogFilter {
    private String registerID;
    private String filterID;
    private EventLogParams params;
    private EventCallback callback;
    private EventLogFilterStatus status = EventLogFilterStatus.WAITING_REQUEST;
    private ChannelHandlerContext ctx = null;
    private BigInteger lastBlockNumber = null;
    private long logCount = 0L;

    public String getNewParamJsonString(String groupId) throws JsonProcessingException {
        String newFilterId = EventSubscribe.newSeq();
        EventLogRequestParams requestParams = new EventLogRequestParams(this.generateNewParams(), groupId, newFilterId);
        this.filterID = newFilterId;
        String content = requestParams.toJsonString();
        return content;
    }

    public String getParamJsonString(String groupId, String filterId) throws JsonProcessingException {
        EventLogRequestParams requestParams = new EventLogRequestParams(this.generateNewParams(), groupId, filterId);
        String content = requestParams.toJsonString();
        return content;
    }

    private EventLogParams generateNewParams() {
        EventLogParams params = new EventLogParams();
        params.setToBlock(this.getParams().getToBlock());
        params.setAddresses(this.getParams().getAddresses());
        params.setTopics(this.getParams().getTopics());
        if (this.lastBlockNumber == null) {
            params.setFromBlock(params.getFromBlock());
        } else {
            params.setFromBlock(this.lastBlockNumber.toString());
        }
        return params;
    }

    public void updateCountsAndLatestBlock(List<EventLog> logs) {
        if (logs.isEmpty()) {
            return;
        }
        EventLog latestOne = logs.get(logs.size() - 1);
        if (this.lastBlockNumber == null) {
            this.lastBlockNumber = latestOne.getBlockNumber();
            this.logCount += (long)logs.size();
        } else if (latestOne.getBlockNumber().compareTo(this.lastBlockNumber) > 0) {
            this.lastBlockNumber = latestOne.getBlockNumber();
            this.logCount += (long)logs.size();
        }
    }

    public String getRegisterID() {
        return this.registerID;
    }

    public void setRegisterID(String registerID) {
        this.registerID = registerID;
    }

    public EventLogParams getParams() {
        return this.params;
    }

    public void setParams(EventLogParams params) {
        this.params = params;
    }

    public EventLogFilterStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventLogFilterStatus status) {
        this.status = status;
    }

    public EventCallback getCallback() {
        return this.callback;
    }

    public void setCallback(EventCallback callback) {
        this.callback = callback;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public class EventLogRequestParams
    extends EventLogParams {
        private String groupID;
        private String filterID;
        private int timeout = 0;

        public EventLogRequestParams(EventLogParams params, String groupID, String filterID) {
            this.setFromBlock(params.getFromBlock());
            this.setToBlock(params.getToBlock());
            this.setAddresses(params.getAddresses());
            this.setTopics(params.getTopics());
            this.setGroupID(groupID);
            this.setFilterID(filterID);
        }

        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }

        public void setFilterID(String filterID) {
            this.filterID = filterID;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public String getFilterID() {
            return this.filterID;
        }

        public String toJsonString() throws JsonProcessingException {
            String content = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)this);
            return content;
        }
    }
}

