/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.eventsub.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.fisco.bcos.sdk.eventsub.EventCallback;
import org.fisco.bcos.sdk.eventsub.filter.EventLogFilter;
import org.fisco.bcos.sdk.eventsub.filter.EventLogResponse;
import org.fisco.bcos.sdk.eventsub.filter.EventSubNodeRespStatus;
import org.fisco.bcos.sdk.eventsub.filter.FilterManager;
import org.fisco.bcos.sdk.model.EventLog;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.fisco.bcos.sdk.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPushMsgHandler
implements MsgHandler {
    private static final Logger logger = LoggerFactory.getLogger(EventPushMsgHandler.class);
    FilterManager filterManager;

    public EventPushMsgHandler(FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx) {
        logger.warn("onConnect accidentally called");
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Message msg) {
        String content = new String(msg.getData());
        try {
            List<EventLog> logs;
            EventLogResponse resp = (EventLogResponse)ObjectMapperFactory.getObjectMapper().readValue(content, EventLogResponse.class);
            if (resp == null || StringUtils.isEmpty(resp.getFilterID())) {
                logger.error(" event log response invalid format, content: {}", (Object)content);
                return;
            }
            EventCallback callback = this.filterManager.getCallBack(resp.getFilterID());
            if (callback == null) {
                logger.debug(" event log push message cannot find callback, filterID: {}, content: {}", (Object)resp.getFilterID(), (Object)content);
                return;
            }
            if (resp.getResult() == EventSubNodeRespStatus.SUCCESS.getStatus() && !(logs = resp.getLogs()).isEmpty()) {
                callback.onReceiveLog(resp.getResult(), logs);
                EventLogFilter filter = this.filterManager.getFilterById(resp.getFilterID());
                if (filter != null) {
                    filter.updateCountsAndLatestBlock(logs);
                } else {
                    logger.error("cannot find filter to update log count and latest block ");
                }
                logger.info(" log size: {}, blocknumber: {}", (Object)logs.size(), (Object)logs.get(0).getBlockNumber());
            }
        }
        catch (JsonProcessingException e) {
            logger.error("EventLogResponse error : " + e.getMessage());
        }
    }

    @Override
    public void onDisconnect(ChannelHandlerContext ctx) {
        logger.info(" filter connection disconnect");
        this.filterManager.updateEventLogFilterStatus(ctx);
    }
}

