/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.network;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.network.ConnectionManager;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ChannelHandler
extends SimpleChannelInboundHandler<Message> {
    private static Logger logger = LoggerFactory.getLogger(ChannelHandler.class);
    private MsgHandler msgHandler;
    private ConnectionManager connectionManager;
    private ExecutorService msgHandleThreadPool;

    public void setMsgHandleThreadPool(ExecutorService msgHandleThreadPool) {
        this.msgHandleThreadPool = msgHandleThreadPool;
    }

    public ChannelHandler(ConnectionManager connManager, MsgHandler msgHandler) {
        this.msgHandler = msgHandler;
        this.connectionManager = connManager;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
        Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            switch (e.state()) {
                case READER_IDLE: 
                case WRITER_IDLE: 
                case ALL_IDLE: {
                    logger.error(" idle state event:{} connect{}:{} long time Inactive, disconnect", new Object[]{e.state(), host, port});
                    this.channelInactive(ctx);
                    ctx.disconnect();
                    ctx.close();
                    break;
                }
            }
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent e = (SslHandshakeCompletionEvent)evt;
            if (e.isSuccess()) {
                logger.info(" handshake success, host: {}, port: {}, ctx: {}", new Object[]{host, port, System.identityHashCode(ctx)});
                ChannelHandlerContext oldCtx = this.connectionManager.addConnectionContext(host, port, ctx);
                this.msgHandler.onConnect(ctx);
                if (Objects.nonNull(oldCtx)) {
                    oldCtx.close();
                    oldCtx.disconnect();
                    logger.warn(" disconnect old connection, host: {}, port: {}, ctx: {}", new Object[]{host, port, System.identityHashCode(ctx)});
                }
            } else {
                logger.error(" handshake failed, host: {}, port: {}, message: {}, cause: {} ", new Object[]{host, port, e.cause().getMessage(), e.cause()});
                ctx.disconnect();
                ctx.close();
            }
        } else if (evt instanceof SslCloseCompletionEvent) {
            logger.info(" ssl close completion event, host: {}, port: {}, ctx: {} ", new Object[]{host, port, System.identityHashCode(ctx)});
        } else {
            logger.info(" userEventTriggered event, host: {}, port: {}, evt: {}, ctx: {} ", new Object[]{host, port, evt, System.identityHashCode(ctx)});
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
            Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
            logger.debug(" channelInactive, disconnect " + host + ":" + String.valueOf(port) + " ," + String.valueOf(ctx.channel().isActive()));
            this.connectionManager.removeConnectionContext(host, port, ctx);
            this.msgHandler.onDisconnect(ctx);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        final ChannelHandlerContext ctxF = ctx;
        final Message in = (Message)msg;
        if (this.msgHandleThreadPool == null) {
            this.msgHandler.onMessage(ctxF, in);
        } else {
            this.msgHandleThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    ChannelHandler.this.msgHandler.onMessage(ctxF, in);
                }
            });
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message msg) {
        ChannelHandlerContext ctxF = ctx;
        this.msgHandler.onMessage(ctxF, msg);
    }
}

