/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SMSslClientContextFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.network.ChannelHandler;
import org.fisco.bcos.sdk.network.ConnectionInfo;
import org.fisco.bcos.sdk.network.MessageDecoder;
import org.fisco.bcos.sdk.network.MessageEncoder;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.network.NetworkException;
import org.fisco.bcos.sdk.network.TimeoutConfig;
import org.fisco.bcos.sdk.utils.ThreadPoolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private ChannelHandler channelHandler;
    private List<ConnectionInfo> connectionInfoList = new CopyOnWriteArrayList<ConnectionInfo>();
    private Map<String, ChannelHandlerContext> availableConnections = new ConcurrentHashMap<String, ChannelHandlerContext>();
    private EventLoopGroup workerGroup;
    private Boolean running = false;
    private Bootstrap bootstrap = new Bootstrap();
    private ScheduledExecutorService reconnSchedule = new ScheduledThreadPoolExecutor(1);

    public ConnectionManager(ConfigOption configOption, MsgHandler msgHandler) {
        for (String peerIpPort : configOption.getNetworkConfig().getPeers()) {
            this.connectionInfoList.add(new ConnectionInfo(peerIpPort));
        }
        this.channelHandler = new ChannelHandler(this, msgHandler);
        logger.info(" all connections: {}", this.connectionInfoList);
    }

    public void startConnect(ConfigOption configOption) throws NetworkException {
        if (this.running.booleanValue()) {
            logger.debug("running");
            return;
        }
        logger.debug(" start connect. ");
        this.initNetty(configOption);
        this.running = true;
        ArrayList<ChannelFuture> connChannelFuture = new ArrayList<ChannelFuture>();
        for (ConnectionInfo connect : this.connectionInfoList) {
            logger.debug("startConnect to {}", (Object)connect.getEndPoint());
            ChannelFuture channelFuture = this.bootstrap.connect(connect.getIp(), connect.getPort().intValue());
            connChannelFuture.add(channelFuture);
        }
        boolean atLeastOneConnectSuccess = false;
        ArrayList<RetCode> errorMessageList = new ArrayList<RetCode>();
        for (int i = 0; i < this.connectionInfoList.size(); ++i) {
            ChannelFuture connectFuture;
            ConnectionInfo connInfo = this.connectionInfoList.get(i);
            if (!this.checkConnectionResult(connInfo, connectFuture = (ChannelFuture)connChannelFuture.get(i), errorMessageList)) continue;
            atLeastOneConnectSuccess = true;
        }
        if (!atLeastOneConnectSuccess) {
            logger.error(" all connections have failed, {} ", errorMessageList);
            String errorMessageString = "";
            for (RetCode errorRetCode : errorMessageList) {
                errorMessageString = errorMessageString + errorRetCode.getMessage() + "\n";
            }
            for (RetCode errorRetCode : errorMessageList) {
                if (errorRetCode.getCode() != 1) continue;
                throw new NetworkException(" Failed to connect to all the nodes! errorMessage: \n" + errorMessageString, 1);
            }
            throw new NetworkException(" Failed to connect to all the nodes! errorMessage: \n" + errorMessageString, 2);
        }
        logger.debug(" start connect end. ");
    }

    public void startReconnectSchedule() {
        logger.debug(" start reconnect schedule");
        this.reconnSchedule.scheduleAtFixedRate(() -> this.reconnect(), TimeoutConfig.reconnectDelay, TimeoutConfig.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    public void stopReconnectSchedule() {
        ThreadPoolService.stopThreadPool(this.reconnSchedule);
    }

    public void stopNetty() {
        if (this.running.booleanValue()) {
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
            this.running = false;
        }
    }

    private void reconnect() {
        ArrayList<ConnectionInfo> needReconnect = new ArrayList<ConnectionInfo>();
        int aliveConnectionCount = 0;
        for (ConnectionInfo connectionInfo : this.connectionInfoList) {
            ChannelHandlerContext ctx = this.availableConnections.get(connectionInfo.getEndPoint());
            if (Objects.isNull(ctx) || !ctx.channel().isActive()) {
                needReconnect.add(connectionInfo);
                continue;
            }
            ++aliveConnectionCount;
        }
        logger.trace(" Keep alive nodes count: {}", (Object)aliveConnectionCount);
        for (ConnectionInfo connectionInfo : needReconnect) {
            ArrayList<RetCode> errorMessageList;
            ChannelFuture connectFuture;
            if (this.checkConnectionResult(connectionInfo, connectFuture = this.bootstrap.connect(connectionInfo.getIp(), connectionInfo.getPort().intValue()), errorMessageList = new ArrayList<RetCode>())) {
                logger.info(" reconnect to {}:{} success", (Object)connectionInfo.getIp(), (Object)connectionInfo.getPort());
                continue;
            }
            logger.error(" reconnect to {}:{}, error: {}", new Object[]{connectionInfo.getIp(), connectionInfo.getPort(), errorMessageList});
        }
    }

    public void setMsgHandleThreadPool(ExecutorService msgHandleThreadPool) {
        this.channelHandler.setMsgHandleThreadPool(msgHandleThreadPool);
    }

    public List<ConnectionInfo> getConnectionInfoList() {
        return this.connectionInfoList;
    }

    public Map<String, ChannelHandlerContext> getAvailableConnections() {
        return this.availableConnections;
    }

    public ChannelHandlerContext getConnectionCtx(String peer) {
        return this.availableConnections.get(peer);
    }

    private SslContext initSslContext(ConfigOption configOption) throws NetworkException {
        try {
            Security.setProperty("jdk.disabled.namedCurves", "");
            System.setProperty("jdk.sunec.disableNative", "false");
            FileInputStream caCert = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getCaCertPath()));
            FileInputStream sslCert = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getSdkCertPath()));
            FileInputStream sslKey = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath()));
            logger.info(" build ECDSA ssl context with configured certificates ");
            SslContext sslCtx = SslContextBuilder.forClient().trustManager((InputStream)caCert).keyManager((InputStream)sslCert, (InputStream)sslKey).sslProvider(SslProvider.OPENSSL).build();
            return sslCtx;
        }
        catch (FileNotFoundException | SSLException e) {
            logger.error("initSslContext failed, caCert: {}, sslCert: {}, sslKey: {}, error: {}, e: {}", new Object[]{configOption.getCryptoMaterialConfig().getCaCertPath(), configOption.getCryptoMaterialConfig().getSdkCertPath(), configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath(), e.getMessage(), e});
            throw new NetworkException("SSL context init failed, please make sure your cert and key files are properly configured. error info: " + e.getMessage(), 3);
        }
        catch (IllegalArgumentException e) {
            logger.error("initSslContext failed, error: {}, e: {}", (Object)e.getMessage(), (Object)e);
            throw new NetworkException("SSL context init failed, error info: " + e.getMessage(), 3);
        }
    }

    private SslContext initSMSslContext(ConfigOption configOption) throws NetworkException {
        try {
            FileInputStream caCert = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getCaCertPath()));
            FileInputStream sslCert = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getSdkCertPath()));
            FileInputStream sslKey = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath()));
            FileInputStream enCert = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getEnSSLCertPath()));
            FileInputStream enKey = new FileInputStream(new File(configOption.getCryptoMaterialConfig().getEnSSLPrivateKeyPath()));
            logger.info(" build SM ssl context with configured certificates ");
            return SMSslClientContextFactory.build((InputStream)caCert, (InputStream)enCert, (InputStream)enKey, (InputStream)sslCert, (InputStream)sslKey);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | InvalidKeySpecException e) {
            logger.error("initSMSslContext failed, caCert:{}, sslCert: {}, sslKey: {}, enCert: {}, enKey: {}, error: {}, e: {}", new Object[]{configOption.getCryptoMaterialConfig().getCaCertPath(), configOption.getCryptoMaterialConfig().getSdkCertPath(), configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath(), configOption.getCryptoMaterialConfig().getEnSSLCertPath(), configOption.getCryptoMaterialConfig().getEnSSLPrivateKeyPath(), e.getMessage(), e});
            throw new NetworkException("SSL context init failed, please make sure your cert and key files are properly configured. error info: " + e.getMessage(), e);
        }
    }

    private void initNetty(ConfigOption configOption) throws NetworkException {
        SslContext sslContext;
        this.workerGroup = new NioEventLoopGroup();
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)TimeoutConfig.connectTimeout));
        int sslCryptoType = configOption.getCryptoMaterialConfig().getSslCryptoType();
        final SslContext finalSslContext = sslContext = sslCryptoType == 0 ? this.initSslContext(configOption) : this.initSMSslContext(configOption);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SslHandler sslHandler = finalSslContext.newHandler(ch.alloc());
                sslHandler.setHandshakeTimeoutMillis(TimeoutConfig.sslHandShakeTimeout);
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{sslHandler, new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0), new IdleStateHandler(TimeoutConfig.idleTimeout, TimeoutConfig.idleTimeout, TimeoutConfig.idleTimeout, TimeUnit.MILLISECONDS), new MessageEncoder(), new MessageDecoder(), ConnectionManager.this.channelHandler});
            }
        };
        this.bootstrap.handler((io.netty.channel.ChannelHandler)initializer);
    }

    private boolean checkConnectionResult(ConnectionInfo connInfo, ChannelFuture connectFuture, List<RetCode> errorMessageList) {
        connectFuture.awaitUninterruptibly();
        if (!connectFuture.isSuccess()) {
            if (Objects.isNull(connectFuture.cause())) {
                logger.error("connect to {}:{} failed. ", (Object)connInfo.getIp(), (Object)connInfo.getPort());
            } else {
                logger.error("connect to {}:{} failed. {}", new Object[]{connInfo.getIp(), connInfo.getPort(), connectFuture.cause().getMessage()});
            }
            errorMessageList.add(new RetCode(2, "connect to " + connInfo.getIp() + ":" + connInfo.getPort() + " failed"));
            return false;
        }
        SslHandler sslhandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
        String checkerMessage = "! Please check the certificate and ensure that the SDK and the node are in the same agency!";
        if (Objects.isNull(sslhandler)) {
            String sslHandshakeFailedMessage = " ssl handshake failed:/" + connInfo.getIp() + ":" + connInfo.getPort() + checkerMessage;
            logger.error(sslHandshakeFailedMessage);
            errorMessageList.add(new RetCode(1, sslHandshakeFailedMessage));
            return false;
        }
        Future sshHandshakeFuture = sslhandler.handshakeFuture().awaitUninterruptibly();
        if (sshHandshakeFuture.isSuccess()) {
            logger.trace(" ssl handshake success {}:{}", (Object)connInfo.getIp(), (Object)connInfo.getPort());
            return true;
        }
        String sslHandshakeFailedMessage = " ssl handshake failed:/" + connInfo.getIp() + ":" + connInfo.getPort() + checkerMessage;
        logger.error(sslHandshakeFailedMessage);
        errorMessageList.add(new RetCode(1, sslHandshakeFailedMessage));
        return false;
    }

    protected ChannelHandlerContext addConnectionContext(String ip, int port, ChannelHandlerContext ctx) {
        String endpoint = ip + ":" + port;
        logger.debug("addConnectionContext, endpoint: {}, ctx:{}", (Object)endpoint, (Object)ctx);
        return this.availableConnections.put(endpoint, ctx);
    }

    protected void removeConnectionContext(String ip, int port, ChannelHandlerContext ctx) {
        String endpoint = ip + ":" + port;
        if (Objects.isNull(this.availableConnections.get(endpoint))) {
            return;
        }
        Boolean result = this.availableConnections.remove(endpoint, ctx);
        if (logger.isDebugEnabled()) {
            logger.debug(" result: {}, host: {}, port: {}, ctx: {}", new Object[]{result, ip, port, System.identityHashCode(ctx)});
        }
    }

    protected void removeConnection(String peerIpPort) {
        for (ConnectionInfo conn : this.connectionInfoList) {
            String ipPort = conn.getIp() + ":" + conn.getPort();
            if (!ipPort.equals(peerIpPort)) continue;
            this.connectionInfoList.remove(conn);
            return;
        }
    }
}

