/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.network;

import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.network.ConnectionInfo;
import org.fisco.bcos.sdk.network.ConnectionManager;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.network.Network;
import org.fisco.bcos.sdk.network.NetworkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkImp
implements Network {
    private static Logger logger = LoggerFactory.getLogger(NetworkImp.class);
    private ConnectionManager connManager;
    private ConfigOption configOption;
    private MsgHandler handler;

    public NetworkImp(ConfigOption configOption, MsgHandler handler) throws ConfigException {
        this.configOption = configOption;
        this.handler = handler;
        this.connManager = new ConnectionManager(configOption, handler);
    }

    @Override
    public ConfigOption getConfigOption() {
        return this.configOption;
    }

    @Override
    public int getSslCryptoType() {
        return this.configOption.getCryptoMaterialConfig().getSslCryptoType();
    }

    @Override
    public void broadcast(Message out) {
        Map<String, ChannelHandlerContext> conns = this.connManager.getAvailableConnections();
        conns.forEach((peer, ctx) -> {
            ctx.writeAndFlush((Object)out);
            logger.trace("send message to  {} success ", peer);
        });
    }

    @Override
    public void sendToPeer(Message out, String peerIpPort) throws NetworkException {
        ChannelHandlerContext ctx = this.connManager.getConnectionCtx(peerIpPort);
        if (!Objects.isNull(ctx)) {
            logger.warn("send message to  {} failed ", (Object)peerIpPort);
            throw new NetworkException("Peer not available. Peer: " + peerIpPort);
        }
        ctx.writeAndFlush((Object)out);
        logger.trace("send message to  {} success ", (Object)peerIpPort);
    }

    @Override
    public List<ConnectionInfo> getConnectionInfo() {
        return this.connManager.getConnectionInfoList();
    }

    private CheckCertExistenceResult checkCertExistence(boolean isSM) {
        CheckCertExistenceResult result = new CheckCertExistenceResult();
        result.setCheckPassed(true);
        String errorMessage = "";
        errorMessage = errorMessage + "Please make sure ";
        if (!new File(this.configOption.getCryptoMaterialConfig().getCaCertPath()).exists()) {
            result.setCheckPassed(false);
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getCaCertPath() + " ";
        }
        if (!new File(this.configOption.getCryptoMaterialConfig().getSdkCertPath()).exists()) {
            result.setCheckPassed(false);
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getSdkCertPath() + " ";
        }
        if (!new File(this.configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath()).exists()) {
            result.setCheckPassed(false);
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getSdkPrivateKeyPath() + " ";
        }
        if (!isSM) {
            errorMessage = errorMessage + "exists!";
            result.setErrorMessage(errorMessage);
            return result;
        }
        if (!new File(this.configOption.getCryptoMaterialConfig().getEnSSLCertPath()).exists()) {
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getEnSSLCertPath() + " ";
            result.setCheckPassed(false);
        }
        if (!new File(this.configOption.getCryptoMaterialConfig().getEnSSLPrivateKeyPath()).exists()) {
            errorMessage = errorMessage + this.configOption.getCryptoMaterialConfig().getEnSSLPrivateKeyPath() + " ";
            result.setCheckPassed(false);
        }
        errorMessage = errorMessage + "exist!";
        result.setErrorMessage(errorMessage);
        return result;
    }

    @Override
    public void start() throws NetworkException {
        boolean tryEcdsaConnect = false;
        CheckCertExistenceResult result = null;
        try {
            try {
                result = this.checkCertExistence(false);
                if (result.isCheckPassed()) {
                    logger.debug("start connManager with ECDSA sslContext");
                    this.connManager.startConnect(this.configOption);
                    this.connManager.startReconnectSchedule();
                    tryEcdsaConnect = true;
                    return;
                }
                logger.warn("Try to connect node with ECDSA sslContext failed, expected certPath: " + this.configOption.getCryptoMaterialConfig().toString() + ", currentPath: " + new File("").getAbsolutePath());
            }
            catch (NetworkException e) {
                tryEcdsaConnect = true;
                this.configOption.reloadConfig(1);
                result = this.checkCertExistence(true);
                if (e.getErrorCode() == 2 || !result.isCheckPassed()) {
                    throw e;
                }
                this.connManager.stopNetty();
                logger.debug("start connManager with the ECDSA sslContext failed, try to use SM sslContext, error info: {}", (Object)e.getMessage());
            }
            logger.debug("start connManager with SM sslContext");
            this.configOption.reloadConfig(1);
            result = this.checkCertExistence(true);
            if (!result.isCheckPassed()) {
                if (tryEcdsaConnect) {
                    throw new NetworkException("Certificate not exist:" + result.getErrorMessage());
                }
                throw new NetworkException("Not providing all the certificates to connect to the node! Please provide the certificates to connect with the block-chain, expected certPath: [" + this.configOption.getCryptoMaterialConfig().toString() + "]");
            }
            if (tryEcdsaConnect) {
                this.connManager = new ConnectionManager(this.configOption, this.handler);
            }
            this.connManager.startConnect(this.configOption);
            this.connManager.startReconnectSchedule();
        }
        catch (ConfigException e) {
            throw new NetworkException("start connManager with the SM algorithm failed, error info: " + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, ChannelHandlerContext> getAvailableConnections() {
        return this.connManager.getAvailableConnections();
    }

    @Override
    public void removeConnection(String peerIpPort) {
        this.connManager.removeConnection(peerIpPort);
    }

    @Override
    public void setMsgHandleThreadPool(ExecutorService threadPool) {
        this.connManager.setMsgHandleThreadPool(threadPool);
    }

    @Override
    public void stop() {
        logger.debug("stop Network...");
        this.connManager.stopReconnectSchedule();
        this.connManager.stopNetty();
    }

    private class CheckCertExistenceResult {
        private boolean checkPassed = true;
        private String errorMessage = "";

        private CheckCertExistenceResult() {
        }

        public boolean isCheckPassed() {
            return this.checkPassed;
        }

        public void setCheckPassed(boolean checkPassed) {
            this.checkPassed = checkPassed;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

