/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.codec.encode;

import java.util.ArrayList;
import java.util.List;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.signature.Signature;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.rlp.RlpEncoder;
import org.fisco.bcos.sdk.rlp.RlpList;
import org.fisco.bcos.sdk.rlp.RlpString;
import org.fisco.bcos.sdk.rlp.RlpType;
import org.fisco.bcos.sdk.transaction.codec.encode.TransactionEncoderInterface;
import org.fisco.bcos.sdk.transaction.model.po.RawTransaction;
import org.fisco.bcos.sdk.transaction.signer.TransactionSignerInterface;
import org.fisco.bcos.sdk.transaction.signer.TransactionSignerServcie;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionEncoderService
implements TransactionEncoderInterface {
    protected static Logger logger = LoggerFactory.getLogger(TransactionEncoderService.class);
    private final Signature signature;
    private final TransactionSignerInterface transactionSignerService;
    private final CryptoSuite cryptoSuite;

    public TransactionEncoderService(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
        this.signature = cryptoSuite.getSignatureImpl();
        this.transactionSignerService = new TransactionSignerServcie(this.signature);
    }

    @Override
    public String encodeAndSign(RawTransaction rawTransaction, CryptoKeyPair cryptoKeyPair) {
        return Numeric.toHexString(this.encodeAndSignBytes(rawTransaction, cryptoKeyPair));
    }

    @Override
    public byte[] encodeAndSignBytes(RawTransaction rawTransaction, CryptoKeyPair cryptoKeyPair) {
        byte[] encodedTransaction = this.encode(rawTransaction, null);
        byte[] hash = this.cryptoSuite.hash(encodedTransaction);
        SignatureResult result = this.transactionSignerService.sign(Hex.toHexString(hash), cryptoKeyPair);
        return this.encode(rawTransaction, result);
    }

    @Override
    public byte[] encode(RawTransaction transaction, SignatureResult signature) {
        List<RlpType> values = TransactionEncoderService.asRlpValues(transaction, signature);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode(rlpList);
    }

    public static List<RlpType> asRlpValues(RawTransaction rawTransaction, SignatureResult signatureResult) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add(RlpString.create(rawTransaction.getRandomid()));
        result.add(RlpString.create(rawTransaction.getGasPrice()));
        result.add(RlpString.create(rawTransaction.getGasLimit()));
        result.add(RlpString.create(rawTransaction.getBlockLimit()));
        String to = rawTransaction.getTo();
        if (to != null && to.length() > 0) {
            result.add(RlpString.create(Numeric.hexStringToByteArray(to)));
        } else {
            result.add(RlpString.create(""));
        }
        result.add(RlpString.create(rawTransaction.getValue()));
        byte[] data = Numeric.hexStringToByteArray(rawTransaction.getData());
        result.add(RlpString.create(data));
        result.add(RlpString.create(rawTransaction.getFiscoChainId()));
        result.add(RlpString.create(rawTransaction.getGroupId()));
        if (rawTransaction.getExtraData() == null) {
            result.add(RlpString.create(""));
        } else {
            result.add(RlpString.create(Numeric.hexStringToByteArray(rawTransaction.getExtraData())));
        }
        if (signatureResult != null) {
            result.addAll(signatureResult.encode());
        }
        return result;
    }

    public Signature getSignature() {
        return this.signature;
    }
}

