/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.manager;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.abi.ABICodec;
import org.fisco.bcos.sdk.abi.ABICodecException;
import org.fisco.bcos.sdk.abi.wrapper.ABIObject;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.client.protocol.response.Call;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.codec.decode.TransactionDecoderInterface;
import org.fisco.bcos.sdk.transaction.codec.decode.TransactionDecoderService;
import org.fisco.bcos.sdk.transaction.manager.AssembleTransactionProcessorInterface;
import org.fisco.bcos.sdk.transaction.manager.TransactionProcessor;
import org.fisco.bcos.sdk.transaction.model.dto.CallRequest;
import org.fisco.bcos.sdk.transaction.model.dto.CallResponse;
import org.fisco.bcos.sdk.transaction.model.dto.ResultCodeEnum;
import org.fisco.bcos.sdk.transaction.model.dto.TransactionResponse;
import org.fisco.bcos.sdk.transaction.model.exception.NoSuchTransactionFileException;
import org.fisco.bcos.sdk.transaction.model.exception.TransactionBaseException;
import org.fisco.bcos.sdk.transaction.model.exception.TransactionException;
import org.fisco.bcos.sdk.transaction.pusher.TransactionPusherInterface;
import org.fisco.bcos.sdk.transaction.pusher.TransactionPusherService;
import org.fisco.bcos.sdk.transaction.tools.ContractLoader;
import org.fisco.bcos.sdk.transaction.tools.JsonUtils;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleTransactionProcessor
extends TransactionProcessor
implements AssembleTransactionProcessorInterface {
    protected static Logger log = LoggerFactory.getLogger(AssembleTransactionProcessor.class);
    protected final TransactionDecoderInterface transactionDecoder;
    protected final TransactionPusherInterface transactionPusher;
    protected final ABICodec abiCodec;
    private ContractLoader contractLoader;

    public AssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, Integer groupId, String chainId, ContractLoader contractLoader) {
        super(client, cryptoKeyPair, groupId, chainId);
        this.transactionDecoder = new TransactionDecoderService(this.cryptoSuite);
        this.transactionPusher = new TransactionPusherService(client);
        this.abiCodec = new ABICodec(this.cryptoSuite);
        this.contractLoader = contractLoader;
    }

    public AssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, Integer groupId, String chainId, String contractName, String abi, String bin) {
        super(client, cryptoKeyPair, groupId, chainId);
        this.transactionDecoder = new TransactionDecoderService(this.cryptoSuite);
        this.transactionPusher = new TransactionPusherService(client);
        this.abiCodec = new ABICodec(this.cryptoSuite);
        this.contractLoader = new ContractLoader(contractName, abi, bin);
    }

    @Override
    public void deployOnly(String abi, String bin, List<Object> params) throws ABICodecException {
        this.transactionPusher.pushOnly(this.createSignedConstructor(abi, bin, params));
    }

    @Override
    public TransactionReceipt deployAndGetReceipt(String data) {
        String signedData = this.createSignedTransaction(null, data, this.cryptoKeyPair);
        return this.transactionPusher.push(signedData);
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String signedData) {
        TransactionReceipt receipt = this.transactionPusher.push(signedData);
        try {
            return this.transactionDecoder.decodeReceiptWithoutValues(abi, receipt);
        }
        catch (IOException | ABICodecException | TransactionException e) {
            log.error("deploy exception: {}", (Object)e.getMessage());
            return new TransactionResponse(receipt, ResultCodeEnum.EXCEPTION_OCCUR.getCode(), e.getMessage());
        }
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String bin, List<Object> params) throws ABICodecException {
        return this.deployAndGetResponse(abi, this.createSignedConstructor(abi, bin, params));
    }

    @Override
    public TransactionResponse deployAndGetResponseWithStringParams(String abi, String bin, List<String> params) throws ABICodecException {
        return this.deployAndGetResponse(abi, this.createSignedTransaction(null, this.abiCodec.encodeConstructorFromString(abi, bin, params), this.cryptoKeyPair));
    }

    @Override
    public void deployAsync(String abi, String bin, List<Object> params, TransactionCallback callback) throws ABICodecException {
        this.transactionPusher.pushAsync(this.createSignedConstructor(abi, bin, params), callback);
    }

    @Override
    public CompletableFuture<TransactionReceipt> deployAsync(String abi, String bin, List<Object> params) throws ABICodecException {
        return this.transactionPusher.pushAsync(this.createSignedConstructor(abi, bin, params));
    }

    @Override
    public TransactionResponse deployByContractLoader(String contractName, List<Object> args) throws ABICodecException, TransactionBaseException {
        return this.deployAndGetResponse(this.contractLoader.getABIByContractName(contractName), this.contractLoader.getBinaryByContractName(contractName), args);
    }

    @Override
    public void deployByContractLoaderAsync(String contractName, List<Object> args, TransactionCallback callback) throws ABICodecException, NoSuchTransactionFileException {
        this.deployAsync(this.contractLoader.getABIByContractName(contractName), this.contractLoader.getBinaryByContractName(contractName), args, callback);
    }

    @Override
    public void sendTransactionOnly(String signedData) {
        this.transactionPusher.pushOnly(signedData);
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponse(String to, String abi, String functionName, String data) throws TransactionBaseException, ABICodecException {
        String signedData = this.createSignedTransaction(to, data, this.cryptoKeyPair);
        TransactionReceipt receipt = this.transactionPusher.push(signedData);
        try {
            return this.transactionDecoder.decodeReceiptWithValues(abi, functionName, receipt);
        }
        catch (IOException | TransactionException e) {
            log.error("sendTransaction exception: {}", (Object)e.getMessage());
            return new TransactionResponse(receipt, ResultCodeEnum.EXCEPTION_OCCUR.getCode(), e.getMessage());
        }
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponse(String to, String abi, String functionName, List<Object> params) throws ABICodecException, TransactionBaseException {
        String data = this.encodeFunction(abi, functionName, params);
        return this.sendTransactionAndGetResponse(to, abi, functionName, data);
    }

    @Override
    public TransactionResponse sendTransactionWithStringParamsAndGetResponse(String to, String abi, String functionName, List<String> params) throws ABICodecException, TransactionBaseException {
        String data = this.abiCodec.encodeMethodFromString(abi, functionName, params);
        return this.sendTransactionAndGetResponse(to, abi, functionName, data);
    }

    @Override
    public TransactionReceipt sendTransactionAndGetReceiptByContractLoader(String contractName, String contractAddress, String functionName, List<Object> args) throws ABICodecException, TransactionBaseException {
        String data = this.abiCodec.encodeMethod(this.contractLoader.getABIByContractName(contractName), functionName, args);
        return this.sendTransactionAndGetReceipt(contractAddress, data, this.cryptoKeyPair);
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponseByContractLoader(String contractName, String contractAddress, String functionName, List<Object> funcParams) throws ABICodecException, TransactionBaseException {
        return this.sendTransactionAndGetResponse(contractAddress, this.contractLoader.getABIByContractName(contractName), functionName, funcParams);
    }

    @Override
    public void sendTransactionAsync(String signedTransaction, TransactionCallback callback) {
        this.transactionPusher.pushAsync(signedTransaction, callback);
    }

    @Override
    public void sendTransactionAsync(String to, String abi, String functionName, List<Object> params, TransactionCallback callback) throws TransactionBaseException, ABICodecException {
        String data = this.encodeFunction(abi, functionName, params);
        this.sendTransactionAsync(to, data, this.cryptoKeyPair, callback);
    }

    @Override
    public CompletableFuture<TransactionReceipt> sendTransactionAsync(String signedData) {
        return this.transactionPusher.pushAsync(signedData);
    }

    @Override
    public void sendTransactionAndGetReceiptByContractLoaderAsync(String contractName, String contractAddress, String functionName, List<Object> args, TransactionCallback callback) throws ABICodecException, TransactionBaseException {
        String data = this.abiCodec.encodeMethod(this.contractLoader.getABIByContractName(contractName), functionName, args);
        this.sendTransactionAsync(contractAddress, data, this.cryptoKeyPair, callback);
    }

    @Override
    public CallResponse sendCallByContractLoader(String contractName, String contractAddress, String functionName, List<Object> args) throws TransactionBaseException, ABICodecException {
        return this.sendCall(this.cryptoKeyPair.getAddress(), contractAddress, this.contractLoader.getABIByContractName(contractName), functionName, args);
    }

    @Override
    public CallResponse sendCall(String from, String to, String abi, String functionName, List<Object> paramsList) throws TransactionBaseException, ABICodecException {
        String data = this.abiCodec.encodeMethod(abi, functionName, paramsList);
        return this.callAndGetResponse(from, to, abi, functionName, data);
    }

    @Override
    public CallResponse sendCall(CallRequest callRequest) throws TransactionBaseException, ABICodecException {
        Call call = this.executeCall(callRequest);
        CallResponse callResponse = this.parseCallResponseStatus(call.getCallResult());
        String callOutput = call.getCallResult().getOutput();
        Pair<List<Object>, List<ABIObject>> results = this.abiCodec.decodeMethodAndGetOutputObject(callRequest.getAbi(), callOutput);
        callResponse.setValues(JsonUtils.toJson(results.getLeft()));
        callResponse.setReturnObject((List)results.getLeft());
        callResponse.setReturnABIObject((List)results.getRight());
        return callResponse;
    }

    @Override
    public CallResponse sendCallWithStringParams(String from, String to, String abi, String functionName, List<String> paramsList) throws TransactionBaseException, ABICodecException {
        String data = this.abiCodec.encodeMethodFromString(abi, functionName, paramsList);
        return this.callAndGetResponse(from, to, abi, functionName, data);
    }

    public CallResponse callAndGetResponse(String from, String to, String abi, String functionName, String data) throws ABICodecException, TransactionBaseException {
        Call call = this.executeCall(from, to, data);
        CallResponse callResponse = this.parseCallResponseStatus(call.getCallResult());
        Pair<List<Object>, List<ABIObject>> results = this.abiCodec.decodeMethodAndGetOutputObject(abi, functionName, call.getCallResult().getOutput());
        callResponse.setValues(JsonUtils.toJson(results.getLeft()));
        callResponse.setReturnObject((List)results.getLeft());
        callResponse.setReturnABIObject((List)results.getRight());
        return callResponse;
    }

    @Override
    public String createSignedConstructor(String abi, String bin, List<Object> params) throws ABICodecException {
        return this.createSignedTransaction(null, this.abiCodec.encodeConstructor(abi, bin, params), this.cryptoKeyPair);
    }

    @Override
    public String encodeFunction(String abi, String functionName, List<Object> params) throws ABICodecException {
        return this.abiCodec.encodeMethod(abi, functionName, params);
    }

    private CallResponse parseCallResponseStatus(Call.CallOutput callOutput) throws TransactionBaseException {
        CallResponse callResponse = new CallResponse();
        RetCode retCode = ReceiptParser.parseCallOutput(callOutput, "");
        callResponse.setReturnCode(Numeric.decodeQuantity(callOutput.getStatus()).intValue());
        callResponse.setReturnMessage(retCode.getMessage());
        if (!retCode.getMessage().equals(PrecompiledRetCode.CODE_SUCCESS.getMessage())) {
            throw new TransactionBaseException(retCode);
        }
        return callResponse;
    }

    public ContractLoader getContractLoader() {
        return this.contractLoader;
    }
}

