/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.manager;

import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.channel.model.EnumNodeVersion;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.NodeVersion;
import org.fisco.bcos.sdk.transaction.manager.AssembleTransactionProcessor;
import org.fisco.bcos.sdk.transaction.manager.TransactionProcessor;
import org.fisco.bcos.sdk.transaction.tools.ContractLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(TransactionProcessorFactory.class);

    public static Pair<String, Integer> getChainIdAndGroupId(Client client) {
        NodeVersion version = client.getClientNodeVersion();
        String binaryVersion = version.getNodeVersion().getVersion();
        String supportedVersion = version.getNodeVersion().getSupportedVersion();
        logger.debug("getNodeVersion before createTransactionManager, binaryVerison: {}, supportedVersion:{}", (Object)binaryVersion, (Object)supportedVersion);
        if (EnumNodeVersion.BCOS_2_0_0_RC1.equals(binaryVersion) || EnumNodeVersion.BCOS_2_0_0_RC1.equals(supportedVersion)) {
            logger.debug("createTransactionManager for rc1 node");
            return Pair.of(null, null);
        }
        String chainId = version.getNodeVersion().getChainId();
        Integer groupId = client.getGroupId();
        logger.debug("createTransactionManager for >=rc2 node, chainId: {}, groupId: {}", (Object)chainId, (Object)groupId);
        return Pair.of((Object)chainId, (Object)groupId);
    }

    public static TransactionProcessor createTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair) {
        Pair<String, Integer> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new TransactionProcessor(client, cryptoKeyPair, (Integer)pair.getRight(), (String)pair.getLeft());
    }

    public static AssembleTransactionProcessor createAssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair) throws Exception {
        Pair<String, Integer> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new AssembleTransactionProcessor(client, cryptoKeyPair, (Integer)pair.getRight(), (String)pair.getLeft(), null);
    }

    public static AssembleTransactionProcessor createAssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, String abiFilePath, String binFilePath) throws Exception {
        Pair<String, Integer> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        ContractLoader contractLoader = new ContractLoader(abiFilePath, binFilePath);
        return new AssembleTransactionProcessor(client, cryptoKeyPair, (Integer)pair.getRight(), (String)pair.getLeft(), contractLoader);
    }

    public static AssembleTransactionProcessor createAssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, String contractName, String abi, String bin) {
        Pair<String, Integer> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new AssembleTransactionProcessor(client, cryptoKeyPair, (Integer)pair.getRight(), (String)pair.getLeft(), contractName, abi, bin);
    }
}

