/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.client.protocol.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.util.List;
import org.fisco.bcos.sdk.v3.client.protocol.model.GroupNodeGenesisInfo;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosGroupNodeInfo;
import org.fisco.bcos.sdk.v3.model.JsonRpcResponse;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BcosGroupInfo
extends JsonRpcResponse<GroupInfo> {
    @Override
    public GroupInfo getResult() {
        return (GroupInfo)super.getResult();
    }

    @Override
    @JsonDeserialize(using=GroupInfoDeserializer.class)
    public void setResult(GroupInfo result) {
        super.setResult(result);
    }

    public static class GroupNodeGenesisInfoConvert
    implements Converter<String, GroupNodeGenesisInfo> {
        public GroupNodeGenesisInfo convert(String value) {
            try {
                return (GroupNodeGenesisInfo)ObjectMapperFactory.getObjectMapper().readValue(value, GroupNodeGenesisInfo.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructSimpleType(String.class, null);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructSimpleType(GroupNodeGenesisInfo.class, null);
        }
    }

    public static class GroupInfoDeserializer
    extends JsonDeserializer<GroupInfo> {
        private final ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public GroupInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (GroupInfo)this.objectReader.readValue(jsonParser, GroupInfo.class);
            }
            return null;
        }
    }

    public static class GroupInfo {
        private String chainID;
        private String groupID;
        private GroupNodeGenesisInfo genesisConfig;
        private List<BcosGroupNodeInfo.GroupNodeInfo> nodeList;

        public String getChainID() {
            return this.chainID;
        }

        public void setChainID(String chainID) {
            this.chainID = chainID;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }

        public List<BcosGroupNodeInfo.GroupNodeInfo> getNodeList() {
            return this.nodeList;
        }

        public void setNodeList(List<BcosGroupNodeInfo.GroupNodeInfo> nodeList) {
            this.nodeList = nodeList;
        }

        public GroupNodeGenesisInfo getGenesisConfig() {
            return this.genesisConfig;
        }

        @JsonDeserialize(converter=GroupNodeGenesisInfoConvert.class)
        public void setGenesisConfig(GroupNodeGenesisInfo genesisConfig) {
            this.genesisConfig = genesisConfig;
        }

        public String toString() {
            return "GroupInfo{chainID='" + this.chainID + '\'' + ", groupID='" + this.groupID + '\'' + ", genesisConfig=" + this.genesisConfig + ", nodeList=" + this.nodeList + '}';
        }
    }
}

