/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.abi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.FunctionEncoderInterface;
import org.fisco.bcos.sdk.v3.codec.Utils;
import org.fisco.bcos.sdk.v3.codec.abi.TypeEncoder;
import org.fisco.bcos.sdk.v3.codec.datatypes.Function;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.Uint;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;

public class FunctionEncoder
extends FunctionEncoderInterface {
    public FunctionEncoder(CryptoSuite cryptoSuite) {
        super(cryptoSuite);
    }

    @Override
    public byte[] encode(Function function) {
        List<Type> parameters = function.getInputParameters();
        String methodSignature = FunctionEncoder.buildMethodSignature(function.getName(), parameters);
        byte[] methodId = this.buildMethodId(methodSignature);
        return FunctionEncoder.encodeParameters(parameters, methodId);
    }

    public static byte[] encodeConstructor(List<Type> parameters) {
        return FunctionEncoder.encodeParameters(parameters, null);
    }

    public static byte[] encodeParameters(List<Type> parameters, byte[] methodID) {
        int dynamicDataOffset = Utils.getLength(parameters) * 32;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (methodID != null) {
                result.write(methodID);
            }
            ByteArrayOutputStream dynamicData = new ByteArrayOutputStream();
            for (Type parameter : parameters) {
                byte[] encodedValue = TypeEncoder.encode(parameter);
                if (TypeEncoder.isDynamic(parameter)) {
                    byte[] encodedDataOffset = TypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                    result.write(encodedDataOffset);
                    dynamicData.write(encodedValue);
                    dynamicDataOffset += encodedValue.length;
                    continue;
                }
                result.write(encodedValue);
            }
            result.write(dynamicData.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toByteArray();
    }
}

