/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.fisco.bcos.sdk.v3.codec.Utils;
import org.fisco.bcos.sdk.v3.codec.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.v3.codec.datatypes.AbiTypes;
import org.fisco.bcos.sdk.v3.codec.datatypes.Address;
import org.fisco.bcos.sdk.v3.codec.datatypes.Array;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bool;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.Fixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.FixedPointType;
import org.fisco.bcos.sdk.v3.codec.datatypes.Int;
import org.fisco.bcos.sdk.v3.codec.datatypes.IntType;
import org.fisco.bcos.sdk.v3.codec.datatypes.NumericType;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.StructType;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Ufixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.Uint;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Uint160;

public class TypeDecoder {
    public static <T extends Type> T decode(byte[] input, int offset, TypeReference<T> type) throws ClassNotFoundException {
        Class<T> cls = type.getClassType();
        if (NumericType.class.isAssignableFrom(cls)) {
            return TypeDecoder.decodeNumeric(Arrays.copyOfRange(input, offset, input.length), cls);
        }
        if (Address.class.isAssignableFrom(cls)) {
            return (T)TypeDecoder.decodeAddress(Arrays.copyOfRange(input, offset, input.length));
        }
        if (Bool.class.isAssignableFrom(cls)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(cls)) {
            return TypeDecoder.decodeBytes(input, offset, cls);
        }
        if (DynamicBytes.class.isAssignableFrom(cls)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(cls)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset);
        }
        if (StaticArray.class.isAssignableFrom(cls)) {
            int length = ((TypeReference.StaticArrayTypeReference)type).getSize();
            return TypeDecoder.decodeStaticArray(input, offset, type, length);
        }
        if (DynamicArray.class.isAssignableFrom(cls)) {
            return TypeDecoder.decodeDynamicArray(input, offset, type);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    public static Address decodeAddress(byte[] input) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class));
    }

    public static <T extends NumericType> T decodeNumeric(byte[] inputByteArray, Class<T> type) {
        try {
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type) || Fixed.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    public static int decodeUintAsInt(byte[] rawInput, int offset) {
        byte[] input = Arrays.copyOfRange(rawInput, offset, offset + 32);
        int result = 0;
        try {
            result = TypeDecoder.decode(input, 0, TypeReference.create(Uint.class)).getValue().intValue();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Bool decodeBool(byte[] rawInput, int offset) {
        BigInteger numericValue = new BigInteger(Arrays.copyOfRange(rawInput, offset, offset + 32));
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    public static <T extends Bytes> T decodeBytes(byte[] input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    public static <T extends Bytes> T decodeBytes(byte[] input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            byte[] bytes = Arrays.copyOfRange(input, offset, offset + length);
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    public static DynamicBytes decodeDynamicBytes(byte[] input, int offset) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset);
        int valueOffset = offset + 32;
        byte[] bytes = Arrays.copyOfRange(input, valueOffset, valueOffset + encodedLength);
        return new DynamicBytes(bytes);
    }

    public static Utf8String decodeUtf8String(byte[] input, int offset) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    public static <T extends Type> T decodeStaticArray(byte[] input, int offset, TypeReference<T> typeReference, int length) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(elements, length);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, typeReference, length, function);
    }

    public static <T extends Type> T instantiateStaticArray(List<T> elements, int length) {
        try {
            Class<?> arrayClass = Class.forName("org.fisco.bcos.sdk.v3.codec.datatypes.generated.StaticArray" + length);
            return (T)((Type)arrayClass.getConstructor(List.class).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static <T extends Type> T decodeDynamicArray(byte[] input, int offset, TypeReference<T> typeReference) {
        int length = TypeDecoder.decodeUintAsInt(input, offset);
        BiFunction<List, String, Type> function = (elements, typeName) -> new DynamicArray<Type>(AbiTypes.getType(typeName), (List<? extends Type>)elements);
        int valueOffset = offset + 32;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, typeReference, length, function);
    }

    private static <T extends Type> T decodeArrayElements(byte[] input, int offset, TypeReference<T> typeReference, int length, BiFunction<List<T>, String, T> consumer) {
        try {
            Class cls = Utils.getParameterizedTypeFromArray(typeReference);
            if (StructType.class.isAssignableFrom(cls)) {
                ArrayList elements = new ArrayList(length);
                int i = 0;
                int currOffset = offset;
                while (i < length) {
                    Object value = DynamicStruct.class.isAssignableFrom(cls) ? TypeDecoder.decodeDynamicStruct(input, offset + FunctionReturnDecoder.getDataOffset(input, currOffset, typeReference), TypeReference.create(cls)) : TypeDecoder.decodeStaticStruct(input, currOffset, TypeReference.create(cls));
                    elements.add(value);
                    ++i;
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 32;
                }
                String typeName = Utils.getSimpleTypeName(cls);
                return (T)((Type)consumer.apply(elements, typeName));
            }
            if (Array.class.isAssignableFrom(cls)) {
                throw new UnsupportedOperationException("Arrays of arrays are not currently supported for external functions");
            }
            ArrayList elements = new ArrayList(length);
            int currOffset = offset;
            for (int i = 0; i < length; ++i) {
                Object value;
                if (TypeDecoder.isDynamic(cls)) {
                    int getOffset = FunctionReturnDecoder.getDataOffset(input, currOffset, typeReference);
                    value = TypeDecoder.decode(input, offset + getOffset, TypeReference.create(cls));
                    currOffset += 32;
                } else {
                    value = TypeDecoder.decode(input, currOffset, TypeReference.create(cls));
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 32;
                }
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(cls);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }

    static <T extends Type> boolean isDynamic(Class<T> parameter) {
        return DynamicBytes.class.isAssignableFrom(parameter) || Utf8String.class.isAssignableFrom(parameter) || DynamicArray.class.isAssignableFrom(parameter);
    }

    static <T extends Type> int getSingleElementLength(byte[] input, int offset, Class<T> type) {
        if (input.length == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) / 32 + 2;
        }
        if (StaticStruct.class.isAssignableFrom(type)) {
            return Utils.staticStructNestedPublicFieldsFlatList(type).size();
        }
        return 1;
    }

    static <T extends Type> T decodeDynamicStruct(byte[] input, int offset, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStruct(typeReference, elements);
        };
        return (T)TypeDecoder.decodeDynamicStructElements(input, offset, typeReference, function);
    }

    private static <T extends Type> T instantiateStruct(TypeReference<T> typeReference, List<T> parameters) {
        try {
            Constructor ctor = Arrays.stream(typeReference.getClassType().getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom) && declaredConstructor.getParameterTypes().length > 0).findAny().orElseThrow(() -> new RuntimeException("TypeReference struct must contain a constructor with types that extend Type"));
            ctor.setAccessible(true);
            return (T)((Type)ctor.newInstance(parameters.toArray()));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Constructor cannot accept" + Arrays.toString(parameters.toArray()), e);
        }
    }

    private static <T extends Type> T decodeDynamicStructElements(byte[] input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            Class<Type> classType = typeReference.getClassType();
            Constructor constructor = Arrays.stream(classType.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom) && declaredConstructor.getParameterTypes().length > 0).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
            int length = constructor.getParameterCount();
            HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
            int staticOffset = 0;
            ArrayList<Integer> parameterOffsets = new ArrayList<Integer>();
            for (int i = 0; i < length; ++i) {
                Object value;
                Class<?> declaredField = constructor.getParameterTypes()[i];
                TypeReference typeReferenceElement = TypeReference.create(constructor.getGenericParameterTypes()[i]);
                int beginIndex = offset + staticOffset;
                if (TypeDecoder.isDynamic(declaredField)) {
                    int parameterOffset = TypeDecoder.decodeDynamicStructDynamicParameterOffset(Arrays.copyOfRange(input, beginIndex, beginIndex + 32)) + offset;
                    parameterOffsets.add(parameterOffset);
                    staticOffset += 32;
                    continue;
                }
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    value = TypeDecoder.decodeStaticStruct(Arrays.copyOfRange(input, beginIndex, input.length), 0, TypeReference.create(declaredField));
                    staticOffset += Utils.staticStructNestedPublicFieldsFlatList(classType).size() * 32;
                } else {
                    value = TypeDecoder.decode(Arrays.copyOfRange(input, beginIndex, input.length), 0, typeReferenceElement);
                    staticOffset += value.bytes32PaddedLength();
                }
                parameters.put(i, value);
            }
            int dynamicParametersProcessed = 0;
            int dynamicParametersToProcess = TypeDecoder.getDynamicStructDynamicParametersCount(constructor.getParameterTypes());
            for (int i = 0; i < length; ++i) {
                TypeReference typeReferenceElement = TypeReference.create(constructor.getGenericParameterTypes()[i]);
                if (!TypeDecoder.isDynamic(typeReferenceElement.getClassType())) continue;
                boolean isLastParameterInStruct = dynamicParametersProcessed == dynamicParametersToProcess - 1;
                int parameterLength = isLastParameterInStruct ? input.length - (Integer)parameterOffsets.get(dynamicParametersProcessed) : (Integer)parameterOffsets.get(dynamicParametersProcessed + 1) - (Integer)parameterOffsets.get(dynamicParametersProcessed);
                parameters.put(i, TypeDecoder.decodeDynamicParameterFromStruct(input, (Integer)parameterOffsets.get(dynamicParametersProcessed), parameterLength, typeReferenceElement));
                ++dynamicParametersProcessed;
            }
            String typeName = Utils.getSimpleTypeName(classType);
            ArrayList elements = new ArrayList();
            for (int i = 0; i < length; ++i) {
                elements.add(parameters.get(i));
            }
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }

    private static <T extends Type> int getDynamicStructDynamicParametersCount(Class<?>[] cls) {
        return (int)Arrays.stream(cls).filter(c -> TypeDecoder.isDynamic(c)).count();
    }

    private static int decodeDynamicStructDynamicParameterOffset(byte[] input) {
        return TypeDecoder.decodeUintAsInt(input, 0);
    }

    private static <T extends Type> T decodeDynamicParameterFromStruct(byte[] input, int parameterOffset, int parameterLength, TypeReference<T> typeReference) throws ClassNotFoundException {
        byte[] dynamicElementData = Arrays.copyOfRange(input, parameterOffset, parameterOffset + parameterLength);
        T value = DynamicStruct.class.isAssignableFrom(typeReference.getClassType()) ? TypeDecoder.decodeDynamicStruct(dynamicElementData, 0, typeReference) : (DynamicArray.class.isAssignableFrom(typeReference.getClassType()) ? TypeDecoder.decodeDynamicArray(dynamicElementData, 0, typeReference) : TypeDecoder.decode(dynamicElementData, 0, typeReference));
        return value;
    }

    public static <T extends Type> T decodeStaticStruct(byte[] input, int offset, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStruct(typeReference, elements);
        };
        return (T)TypeDecoder.decodeStaticStructElement(input, offset, typeReference, function);
    }

    private static <T extends Type> T decodeStaticStructElement(byte[] input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            Class<T> classType = typeReference.getClassType();
            Constructor constructor = Arrays.stream(classType.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom) && declaredConstructor.getParameterTypes().length > 0).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
            int length = constructor.getParameterCount();
            ArrayList elements = new ArrayList(length);
            int currOffset = offset;
            for (int i = 0; i < length; ++i) {
                Object value;
                Class<?> declaredField = constructor.getParameterTypes()[i];
                TypeReference typeReferenceElement = TypeReference.create(constructor.getGenericParameterTypes()[i]);
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    int nestedStructLength = classType.getDeclaredFields()[i].getType().getConstructors()[0].getParameters().length * 32;
                    value = TypeDecoder.decodeStaticStruct(Arrays.copyOfRange(input, currOffset, currOffset + nestedStructLength), 0, TypeReference.create(declaredField));
                    currOffset += nestedStructLength;
                } else {
                    value = TypeDecoder.decode(Arrays.copyOfRange(input, currOffset, currOffset + 32), 0, typeReferenceElement);
                    currOffset += 32;
                }
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(classType);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }
}

