/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.abi.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractAbiUtil {
    private static final Logger logger = LoggerFactory.getLogger(ContractAbiUtil.class);
    public static final String TYPE_CONSTRUCTOR = "constructor";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_EVENT = "event";

    public static List<ABIDefinition> getFuncABIDefinition(String contractAbi) {
        ArrayList<ABIDefinition> result = new ArrayList<ABIDefinition>();
        try {
            ABIDefinition[] abiDefinitions;
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            for (ABIDefinition ABIDefinition2 : abiDefinitions = (ABIDefinition[])objectMapper.readValue(contractAbi, ABIDefinition[].class)) {
                if (!TYPE_FUNCTION.equals(ABIDefinition2.getType()) && !TYPE_CONSTRUCTOR.equals(ABIDefinition2.getType())) continue;
                result.add(ABIDefinition2);
            }
        }
        catch (JsonProcessingException e) {
            logger.warn(" invalid json, abi: {}, e: {} ", (Object)contractAbi, (Object)e);
        }
        return result;
    }
}

