/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.datatypes;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;

public abstract class Array<T extends Type>
implements Type<List<T>> {
    protected final Class<T> type;
    protected final List<T> value;
    protected boolean isFixed;

    @SafeVarargs
    Array(Class<T> type, T ... values) {
        this(type, Arrays.asList(values));
    }

    Array(Class<T> type, List<T> values) {
        this.valid(type, values);
        this.type = type;
        this.value = values;
        this.isFixed = false;
    }

    @Override
    public int bytes32PaddedLength() {
        int length = 0;
        for (Type t : this.value) {
            int valueLength = t.bytes32PaddedLength();
            length += valueLength;
        }
        return length;
    }

    public Class<T> getComponentType() {
        return this.type;
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    @Override
    public abstract String getTypeAsString();

    private void valid(Class<T> type, List<T> values) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(values);
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array array = (Array)o;
        if (!this.type.equals(array.type)) {
            return false;
        }
        return Objects.equals(this.value, array.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

