/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.scale;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleWriter;
import org.fisco.bcos.sdk.v3.codec.scale.writer.CompactUIntWriter;

public class ScaleCodecWriter
implements Closeable {
    public static final CompactUIntWriter COMPACT_UINT = new CompactUIntWriter();
    private final OutputStream out;

    public ScaleCodecWriter(OutputStream out) {
        this.out = out;
    }

    public void writeByteArray(byte[] value) throws IOException {
        this.out.write(value, 0, value.length);
    }

    public void writeAsList(byte[] value) throws IOException {
        this.writeCompact(value.length);
        this.out.write(value, 0, value.length);
    }

    public void directWrite(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public <T> void write(ScaleWriter<T> writer, T value) throws IOException {
        writer.write(this, value);
    }

    public void writeByte(byte value) throws IOException {
        this.directWrite(value);
    }

    public void writeCompactInteger(BigInteger value) throws IOException {
        if (value.compareTo(EncodingCategoryLimits.kMinUint16) < 0) {
            this.directWrite((byte)(value.longValue() << 2));
            return;
        }
        if (value.compareTo(EncodingCategoryLimits.kMinUint32) < 0) {
            this.writeSecondCategory(value);
            return;
        }
        if (value.compareTo(EncodingCategoryLimits.kMinBigInteger) < 0) {
            this.encodeThirdCategory(value);
            return;
        }
        this.writeBigInteger(value);
    }

    private void encodeThirdCategory(BigInteger value) throws IOException {
        long v = value.longValue();
        v = (v << 2) + 2L;
        this.writeInteger(BigInteger.valueOf(v), 32);
    }

    public void writeUnsignedInteger(BigInteger value, int valueByteSize) throws IOException {
        BigInteger maxSignedValue = BigInteger.ONE.shiftLeft(valueByteSize * 8 - 1).subtract(BigInteger.ONE);
        if (value.compareTo(maxSignedValue) <= 0) {
            this.writeInteger(value, valueByteSize);
            return;
        }
        BigInteger minOverflowUnsignedValue = BigInteger.ONE.shiftLeft(valueByteSize * 8);
        if (value.compareTo(minOverflowUnsignedValue) >= 0) {
            throw new UnsupportedOperationException("writeInteger exception for overflow, value: " + value);
        }
        BigInteger convertedValue = BigInteger.ZERO.subtract(minOverflowUnsignedValue.subtract(value));
        this.writeInteger(convertedValue, valueByteSize);
    }

    public void writeInteger(BigInteger value, int valueByteSize) throws IOException {
        int i;
        byte[] byteArray = new byte[valueByteSize];
        BigInteger v = value;
        byte[] byteValue = v.toByteArray();
        if (byteArray.length < byteValue.length) {
            throw new UnsupportedOperationException("writeInteger exception for overflow, value: " + value);
        }
        for (i = 0; i < byteValue.length; ++i) {
            byteArray[i] = byteValue[byteValue.length - i - 1];
        }
        if (value.compareTo(BigInteger.ZERO) < 0) {
            for (i = byteValue.length; i < valueByteSize; ++i) {
                byteArray[i] = -1;
            }
        }
        this.writeByteArray(byteArray);
    }

    public void writeBigInt256(boolean signed, BigInteger value) throws IOException {
        if (value.compareTo(BigInteger.ZERO) < 0 && !signed) {
            throw new UnsupportedOperationException("Must provide positive data when using unsigned type");
        }
        byte[] valueBytes = value.toByteArray();
        byte size = (byte)valueBytes.length;
        if (size > 32) {
            throw new UnsupportedOperationException("Unsupported unsigned type with length more than 32 bytes");
        }
        byte[] encodedData = new byte[32];
        System.arraycopy(valueBytes, 0, encodedData, 32 - valueBytes.length, valueBytes.length);
        if (signed && value.compareTo(BigInteger.ZERO) < 0) {
            for (int i = 0; i < 32 - valueBytes.length; ++i) {
                encodedData[i] = -1;
            }
        }
        this.writeByteArray(encodedData);
    }

    private void writeSecondCategory(BigInteger value) throws IOException {
        long v = value.longValue();
        v <<= 2;
        byte minorByte = (byte)(++v & 0xFFL);
        byte majorByte = (byte)((v >>= 8) & 0xFFL);
        this.directWrite(minorByte);
        this.directWrite(majorByte);
    }

    private void writeBigInteger(BigInteger value) throws IOException {
        byte[] valueBytes = value.toByteArray();
        int requiredLen = 1 + valueBytes.length;
        if (requiredLen > 67) {
            throw new UnsupportedOperationException("encodeCompactInteger exception for COMPACT_INTEGER_TOO_BIG");
        }
        byte header = (byte)((valueBytes.length - 4) * 4 + 3);
        this.writeByte(header);
        this.writeInteger(value, valueBytes.length);
    }

    public void writeCompact(int value) throws IOException {
        COMPACT_UINT.write(this, value);
    }

    public static class EncodingCategoryLimits {
        public static final BigInteger kMinUint16 = BigInteger.valueOf(64L);
        public static final BigInteger kMinUint32 = BigInteger.valueOf(16384L);
        public static final BigInteger kMinBigInteger = BigInteger.valueOf(0x40000000L);
    }
}

