/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.scale.writer;

import java.io.IOException;
import java.math.BigInteger;
import org.fisco.bcos.sdk.v3.codec.scale.CompactMode;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleCodecWriter;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleWriter;
import org.fisco.bcos.sdk.v3.codec.scale.writer.CompactBigIntWriter;

public class CompactULongWriter
implements ScaleWriter<Long> {
    private static final CompactBigIntWriter BIGINT_WRITER = new CompactBigIntWriter();

    @Override
    public void write(ScaleCodecWriter wrt, Long value) throws IOException {
        CompactMode mode = CompactMode.forNumber(value);
        if (mode == CompactMode.BIGINT) {
            BIGINT_WRITER.write(wrt, BigInteger.valueOf(value));
            return;
        }
        long compact = (value << 2) + (long)mode.getValue();
        for (int bytes = mode == CompactMode.SINGLE ? 1 : (mode == CompactMode.TWO ? 2 : 4); bytes > 0; --bytes) {
            wrt.directWrite((int)compact & 0xFF);
            compact >>= 8;
        }
    }
}

