/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec.wrapper;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.v3.codec.abi.TypeEncoder;
import org.fisco.bcos.sdk.v3.codec.datatypes.Address;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bool;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Bytes32;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Int256;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Uint256;
import org.fisco.bcos.sdk.v3.codec.scale.ScaleCodecReader;
import org.fisco.bcos.sdk.v3.codec.scale.TypeDecoder;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIObject;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractCodecTools {
    private static final Logger logger = LoggerFactory.getLogger(ContractCodecTools.class);

    private static void errorReport(String path, String expected, String actual) throws InvalidParameterException {
        String errorMessage = "Arguments mismatch: " + path + ", expected: " + expected + ", actual: " + actual;
        logger.error(errorMessage);
        throw new InvalidParameterException(errorMessage);
    }

    public static ABIObject decodeAbiObjectListValue(ABIObject template, Object value) {
        ABIObject abiObject = template.newObject();
        if (abiObject.getType() != ABIObject.ObjectType.LIST && abiObject.getType() != ABIObject.ObjectType.STRUCT) {
            ContractCodecTools.errorReport(" abi type mismatch of " + abiObject.getName(), "LIST/STRUCT", abiObject.getType().toString());
        }
        Object list = new ArrayList();
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof DynamicArray) {
            list = ((DynamicArray)value).getValue();
        } else {
            Object[] objs = (Object[])value;
            Collections.addAll(list, objs);
        }
        if (abiObject.getListType() == ABIObject.ListType.FIXED && list.size() != abiObject.getListLength()) {
            ContractCodecTools.errorReport("fixed list arguments size", String.valueOf(abiObject.getListLength()), String.valueOf(list.size()));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            ABIObject nodeObject = abiObject.getListValueType().newObject();
            switch (nodeObject.getType()) {
                case VALUE: {
                    nodeObject = ContractCodecTools.decodeABIObjectValue(nodeObject, obj);
                    break;
                }
                case STRUCT: {
                    nodeObject = ContractCodecTools.decodeAbiObjectStructValue(nodeObject, obj);
                    break;
                }
                case LIST: {
                    nodeObject = ContractCodecTools.decodeAbiObjectListValue(nodeObject, obj);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(" Unsupported objectType: " + (Object)((Object)nodeObject.getType()));
                }
            }
            abiObject.getListValues().add(nodeObject);
        }
        return abiObject;
    }

    public static ABIObject decodeAbiObjectStructValue(ABIObject template, Object value) {
        ABIObject abiObject = template.newObject();
        if (abiObject.getType() != ABIObject.ObjectType.STRUCT) {
            ContractCodecTools.errorReport(" abi type mismatch of " + abiObject.getName(), "STRUCT", abiObject.getType().toString());
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
                ABIObject nodeObject = abiObject.getStructFields().get(i);
                switch (nodeObject.getType()) {
                    case VALUE: {
                        nodeObject = ContractCodecTools.decodeABIObjectValue(nodeObject, list.get(i));
                        break;
                    }
                    case STRUCT: {
                        nodeObject = ContractCodecTools.decodeAbiObjectStructValue(nodeObject, list.get(i));
                        break;
                    }
                    case LIST: {
                        nodeObject = ContractCodecTools.decodeAbiObjectListValue(nodeObject, list.get(i));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(" Unsupported objectType: " + (Object)((Object)nodeObject.getType()));
                    }
                }
                abiObject.getStructFields().set(i, nodeObject);
            }
        } else {
            Field[] fields = value.getClass().getDeclaredFields();
            HashMap<String, Object> v = new HashMap<String, Object>();
            try {
                for (Field f : fields) {
                    f.setAccessible(true);
                    v.put(f.getName(), f.get(value));
                }
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
            for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
                ABIObject nodeObject = abiObject.getStructFields().get(i);
                switch (nodeObject.getType()) {
                    case VALUE: {
                        nodeObject = ContractCodecTools.decodeABIObjectValue(nodeObject, v.get(nodeObject.getName()));
                        break;
                    }
                    case STRUCT: {
                        nodeObject = ContractCodecTools.decodeAbiObjectStructValue(nodeObject, v.get(nodeObject.getName()));
                        break;
                    }
                    case LIST: {
                        nodeObject = ContractCodecTools.decodeAbiObjectListValue(nodeObject, v.get(nodeObject.getName()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(" Unsupported objectType: " + (Object)((Object)nodeObject.getType()));
                    }
                }
                abiObject.getStructFields().set(i, nodeObject);
            }
        }
        return abiObject;
    }

    public static ABIObject decodeABIObjectValue(ABIObject template, Object value) {
        ABIObject abiObject = template.newObject();
        if (abiObject.getType() == ABIObject.ObjectType.LIST) {
            abiObject = ContractCodecTools.decodeAbiObjectListValue(abiObject, value);
        } else if (abiObject.getType() == ABIObject.ObjectType.STRUCT) {
            abiObject = ContractCodecTools.decodeAbiObjectStructValue(abiObject, value);
        } else {
            switch (abiObject.getValueType()) {
                case BOOL: {
                    if (value instanceof Boolean) {
                        abiObject.setBoolValue(new Bool((Boolean)value));
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                case UINT: {
                    if (value instanceof BigInteger) {
                        abiObject.setNumericValue(new Uint256((BigInteger)value));
                        break;
                    }
                    if (NumberUtils.isCreatable((String)value.toString())) {
                        abiObject.setNumericValue(new Uint256(new BigInteger(value.toString())));
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                case INT: {
                    if (value instanceof BigInteger) {
                        abiObject.setNumericValue(new Int256((BigInteger)value));
                        break;
                    }
                    if (NumberUtils.isCreatable((String)value.toString())) {
                        abiObject.setNumericValue(new Uint256(new BigInteger(value.toString())));
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                case ADDRESS: {
                    if (value instanceof String) {
                        abiObject.setAddressValue(new Address((String)value));
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                case BYTES: {
                    if (value instanceof byte[]) {
                        byte[] bytesValue = (byte[])value;
                        abiObject.setBytesValue(new Bytes(bytesValue.length, bytesValue));
                        break;
                    }
                    if (value instanceof Bytes) {
                        abiObject.setBytesValue((Bytes)value);
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                case DBYTES: {
                    if (value instanceof byte[]) {
                        byte[] bytesValue = (byte[])value;
                        abiObject.setDynamicBytesValue(new DynamicBytes(bytesValue));
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                case STRING: {
                    if (value instanceof String) {
                        abiObject.setStringValue(new Utf8String((String)value));
                        break;
                    }
                    ContractCodecTools.errorReport(" valueType mismatch", ((Object)((Object)abiObject.getValueType())).getClass().getName(), value.getClass().getName());
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unrecognized valueType: " + (Object)((Object)abiObject.getValueType()));
                }
            }
        }
        return abiObject;
    }

    private static byte[] typeEncoderWrapper(Type parameter, boolean isWasm) throws IOException {
        return isWasm ? org.fisco.bcos.sdk.v3.codec.scale.TypeEncoder.encode(parameter) : TypeEncoder.encode(parameter);
    }

    private static Type getABIObjectTypeValue(ABIObject abiObject) {
        switch (abiObject.getType()) {
            case VALUE: {
                ABIObject.ValueType valueType = abiObject.getValueType();
                switch (valueType) {
                    case UINT: 
                    case INT: {
                        return abiObject.getNumericValue();
                    }
                    case BOOL: {
                        return abiObject.getBoolValue();
                    }
                    case FIXED: 
                    case UFIXED: {
                        throw new UnsupportedOperationException(" Unsupported fixed/unfixed type. ");
                    }
                    case BYTES: {
                        return abiObject.getBytesValue();
                    }
                    case ADDRESS: {
                        return abiObject.getAddressValue();
                    }
                    case DBYTES: {
                        return abiObject.getDynamicBytesValue();
                    }
                    case STRING: {
                        return abiObject.getStringValue();
                    }
                }
                throw new UnsupportedOperationException(" Unrecognized valueType: " + (Object)((Object)valueType));
            }
            case STRUCT: {
                ArrayList<Type> typeList = new ArrayList<Type>();
                for (ABIObject structField : abiObject.getStructFields()) {
                    typeList.add(ContractCodecTools.getABIObjectTypeValue(structField));
                }
                if (abiObject.isDynamic()) {
                    return new DynamicStruct((List<Type>)typeList);
                }
                return new StaticStruct((List<Type>)typeList);
            }
            case LIST: {
                ArrayList<Type> typeList = new ArrayList<Type>();
                for (ABIObject listValue : abiObject.getListValues()) {
                    typeList.add(ContractCodecTools.getABIObjectTypeValue(listValue));
                }
                if (abiObject.isDynamic()) {
                    DynamicArray<ABIDefinition.Type> dynamicArray = null;
                    dynamicArray = typeList.isEmpty() ? new DynamicArray<ABIDefinition.Type>(ABIDefinition.Type.class, (List<ABIDefinition.Type>)typeList) : new DynamicArray(((Type)typeList.get(0)).getClass(), (List<?>)typeList);
                    dynamicArray.setFixed(abiObject.getListType() == ABIObject.ListType.FIXED);
                    return dynamicArray;
                }
                if (typeList.isEmpty()) {
                    return new StaticArray<ABIDefinition.Type>(ABIDefinition.Type.class, (List<ABIDefinition.Type>)typeList);
                }
                return new StaticArray(((Type)typeList.get(0)).getClass(), (List<?>)typeList);
            }
        }
        throw new UnsupportedOperationException(" Unsupported type: " + (Object)((Object)abiObject.getType()));
    }

    public static byte[] encode(ABIObject abiObject, boolean isWasm) throws IOException {
        return ContractCodecTools.typeEncoderWrapper(ContractCodecTools.getABIObjectTypeValue(abiObject), isWasm);
    }

    public static ABIObject decode(ABIObject template, byte[] input, boolean isWasm) throws ClassNotFoundException {
        if (isWasm) {
            ScaleCodecReader reader = new ScaleCodecReader(input);
            return ContractCodecTools.decodeScale(template, reader);
        }
        return ContractCodecTools.decodeABI(template, input, 0);
    }

    private static ABIObject decodeABI(ABIObject template, byte[] input, int offset) throws ClassNotFoundException {
        ABIObject abiObject = template.newObject();
        switch (abiObject.getType()) {
            case VALUE: {
                switch (abiObject.getValueType()) {
                    case BOOL: {
                        abiObject.setBoolValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(Bool.class)));
                        break;
                    }
                    case UINT: {
                        abiObject.setNumericValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(Uint256.class)));
                        break;
                    }
                    case INT: {
                        abiObject.setNumericValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(Int256.class)));
                        break;
                    }
                    case FIXED: 
                    case UFIXED: {
                        throw new UnsupportedOperationException(" Unsupported fixed/unfixed type. ");
                    }
                    case BYTES: {
                        abiObject.setBytesValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(Bytes32.class)));
                        break;
                    }
                    case ADDRESS: {
                        abiObject.setAddressValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(Address.class)));
                        break;
                    }
                    case DBYTES: {
                        abiObject.setDynamicBytesValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(DynamicBytes.class)));
                        break;
                    }
                    case STRING: {
                        abiObject.setStringValue(org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, offset, TypeReference.create(Utf8String.class)));
                    }
                }
                break;
            }
            case STRUCT: {
                int structOffset = offset;
                int initialOffset = offset;
                for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
                    ABIObject structObject = abiObject.getStructFields().get(i);
                    ABIObject itemObject = null;
                    if (structObject.isDynamic()) {
                        int structValueOffset = org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, structOffset, TypeReference.create(Uint256.class)).getValue().intValue();
                        itemObject = ContractCodecTools.decodeABI(structObject, input, initialOffset + structValueOffset);
                    } else {
                        itemObject = ContractCodecTools.decodeABI(structObject, input, structOffset);
                    }
                    abiObject.getStructFields().set(i, itemObject);
                    structOffset += structObject.offsetAsByteLength();
                }
                break;
            }
            case LIST: {
                int listOffset = offset;
                int initialOffset = offset;
                int listLength = 0;
                if (abiObject.getListType() == ABIObject.ListType.DYNAMIC) {
                    listLength = org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, listOffset, TypeReference.create(Uint256.class)).getValue().intValue();
                    listOffset += 32;
                    initialOffset += 32;
                } else {
                    listLength = abiObject.getListLength();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(" listType: {}, listLength: {}", (Object)abiObject.getListType(), (Object)listLength);
                }
                ABIObject listValueObject = abiObject.getListValueType();
                for (int i = 0; i < listLength; ++i) {
                    ABIObject itemABIObject = null;
                    if (listValueObject.isDynamic()) {
                        int listValueOffset = org.fisco.bcos.sdk.v3.codec.abi.TypeDecoder.decode(input, listOffset, TypeReference.create(Uint256.class)).getValue().intValue();
                        itemABIObject = ContractCodecTools.decodeABI(abiObject.getListValueType(), input, initialOffset + listValueOffset);
                    } else {
                        itemABIObject = ContractCodecTools.decodeABI(abiObject.getListValueType(), input, listOffset);
                    }
                    listOffset += listValueObject.offsetAsByteLength();
                    abiObject.getListValues().add(itemABIObject);
                }
                break;
            }
        }
        return abiObject;
    }

    private static ABIObject decodeScale(ABIObject template, ScaleCodecReader reader) throws ClassNotFoundException {
        ABIObject abiObject = template.newObject();
        switch (abiObject.getType()) {
            case VALUE: {
                switch (abiObject.getValueType()) {
                    case BOOL: {
                        abiObject.setBoolValue(TypeDecoder.decode(reader, TypeReference.create(Bool.class)));
                        break;
                    }
                    case UINT: {
                        abiObject.setNumericValue(TypeDecoder.decode(reader, TypeReference.create(Uint256.class)));
                        break;
                    }
                    case INT: {
                        abiObject.setNumericValue(TypeDecoder.decode(reader, TypeReference.create(Int256.class)));
                        break;
                    }
                    case FIXED: 
                    case UFIXED: {
                        throw new UnsupportedOperationException(" Unsupported fixed/unfixed type. ");
                    }
                    case BYTES: {
                        abiObject.setBytesValue(TypeDecoder.decode(reader, TypeReference.create(Bytes32.class)));
                        break;
                    }
                    case ADDRESS: {
                        abiObject.setAddressValue(TypeDecoder.decode(reader, TypeReference.create(Address.class)));
                        break;
                    }
                    case DBYTES: {
                        abiObject.setDynamicBytesValue(TypeDecoder.decode(reader, TypeReference.create(DynamicBytes.class)));
                        break;
                    }
                    case STRING: {
                        abiObject.setStringValue(TypeDecoder.decode(reader, TypeReference.create(Utf8String.class)));
                    }
                }
                break;
            }
            case STRUCT: {
                for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
                    ABIObject structObject = abiObject.getStructFields().get(i);
                    ABIObject itemObject = null;
                    itemObject = ContractCodecTools.decodeScale(structObject, reader);
                    abiObject.getStructFields().set(i, itemObject);
                }
                break;
            }
            case LIST: {
                int listLength = abiObject.getListType() == ABIObject.ListType.DYNAMIC ? TypeDecoder.decode(reader, TypeReference.create(Uint256.class)).getValue().intValue() : abiObject.getListLength();
                if (logger.isTraceEnabled()) {
                    logger.trace(" listType: {}, listLength: {}", (Object)abiObject.getListType(), (Object)listLength);
                }
                for (int i = 0; i < listLength; ++i) {
                    ABIObject itemABIObject = ContractCodecTools.decodeScale(abiObject.getListValueType(), reader);
                    abiObject.getListValues().add(itemABIObject);
                }
                break;
            }
        }
        return abiObject;
    }

    public static Pair<List<Object>, List<ABIObject>> decodeJavaObjectAndOutputObject(ABIObject template, String input, boolean isWasm) throws ClassNotFoundException {
        if (logger.isTraceEnabled()) {
            logger.trace(" ABIObject: {}, abi: {}", (Object)template, (Object)input);
        }
        ABIObject abiObject = ContractCodecTools.decode(template, Hex.decode(input), isWasm);
        return ContractCodecTools.decodeJavaObjectAndGetOutputObject(abiObject);
    }

    public static List<Object> decodeJavaObject(ABIObject template, String input, boolean isWasm) throws ClassNotFoundException {
        return (List)ContractCodecTools.decodeJavaObjectAndOutputObject(template, input, isWasm).getLeft();
    }

    private static List<Object> decodeJavaObject(ABIObject template) throws UnsupportedOperationException {
        return (List)ContractCodecTools.decodeJavaObjectAndGetOutputObject(template).getLeft();
    }

    public static byte[] formatBytesN(ABIObject abiObject) {
        if (abiObject.getBytesLength() > 0 && abiObject.getBytesValue().getValue().length > abiObject.getBytesLength()) {
            byte[] value = new byte[abiObject.getBytesLength()];
            System.arraycopy(abiObject.getBytesValue().getValue(), 0, value, 0, abiObject.getBytesLength());
            return value;
        }
        return abiObject.getBytesValue().getValue();
    }

    private static Pair<List<Object>, List<ABIObject>> decodeJavaObjectAndGetOutputObject(ABIObject template) throws UnsupportedOperationException {
        ArrayList<Object> result = new ArrayList<Object>();
        List<ABIObject> argObjects = template.getType() == ABIObject.ObjectType.STRUCT ? template.getStructFields() : template.getListValues();
        ArrayList<ABIObject> resultABIObject = new ArrayList<ABIObject>();
        block12: for (int i = 0; i < argObjects.size(); ++i) {
            ABIObject argObject = argObjects.get(i);
            switch (argObject.getType()) {
                case VALUE: {
                    resultABIObject.add(argObject);
                    switch (argObject.getValueType()) {
                        case BOOL: {
                            result.add(argObject.getBoolValue().getValue());
                            continue block12;
                        }
                        case UINT: 
                        case INT: {
                            result.add(argObject.getNumericValue().getValue());
                            continue block12;
                        }
                        case ADDRESS: {
                            result.add(argObject.getAddressValue().toString());
                            continue block12;
                        }
                        case BYTES: {
                            result.add(ContractCodecTools.formatBytesN(argObject));
                            continue block12;
                        }
                        case DBYTES: {
                            result.add(argObject.getDynamicBytesValue().getValue());
                            continue block12;
                        }
                        case STRING: {
                            result.add(argObject.getStringValue().toString());
                            continue block12;
                        }
                    }
                    throw new UnsupportedOperationException(" Unsupported valueType: " + (Object)((Object)argObject.getValueType()));
                }
                case STRUCT: 
                case LIST: {
                    Pair<List<Object>, List<ABIObject>> nodeAndAbiObject = ContractCodecTools.decodeJavaObjectAndGetOutputObject(argObject);
                    result.add(nodeAndAbiObject.getLeft());
                    ABIObject listABIObject = new ABIObject(argObject.getValueType());
                    listABIObject.setListValues((List)nodeAndAbiObject.getRight());
                    resultABIObject.add(listABIObject);
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException(" Unsupported objectType: " + (Object)((Object)argObject.getType()));
                }
            }
        }
        return new ImmutablePair(result, resultABIObject);
    }
}

