/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.config.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.fisco.bcos.sdk.v3.config.model.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfig {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfig.class);
    private List<String> peers;
    private String defaultGroup;
    private int timeout = -1;

    public NetworkConfig() {
    }

    public NetworkConfig(ConfigProperty configProperty) {
        Map<String, Object> networkProperty = configProperty.getNetwork();
        if (networkProperty != null) {
            this.peers = (List)networkProperty.get("peers");
            this.defaultGroup = (String)networkProperty.get("defaultGroup");
            Object value = networkProperty.get("messageTimeout");
            if (Objects.nonNull(value)) {
                this.timeout = Integer.parseInt((String)value);
            }
            logger.info("network config items, timeout: {}, peers: {}", (Object)this.timeout, this.peers);
        }
    }

    public List<String> getPeers() {
        return this.peers;
    }

    public void setPeers(List<String> peers) {
        this.peers = peers;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "NetworkConfig{peers=" + this.peers + ", defaultGroup='" + this.defaultGroup + '\'' + ", timeout=" + this.timeout + '}';
    }
}

