/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.config.model;

import java.util.Map;
import org.fisco.bcos.sdk.v3.config.model.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolConfig {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolConfig.class);
    private int threadPoolSize;

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public ThreadPoolConfig() {
    }

    public ThreadPoolConfig(ConfigProperty configProperty) {
        Map<String, Object> threadPoolConfig = configProperty.getThreadPool();
        String cpuNum = String.valueOf(Runtime.getRuntime().availableProcessors());
        String value = ConfigProperty.getValue(threadPoolConfig, "threadPoolSize", cpuNum);
        this.threadPoolSize = Integer.parseInt(value);
        logger.debug("Init ThreadPoolConfig, threadPoolSize: {}", (Object)this.threadPoolSize);
    }

    public String toString() {
        return "ThreadPoolConfig{threadPoolSize=" + this.threadPoolSize + '}';
    }
}

