/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.fisco.bcos.sdk.jni.utilities.tx.TxPair;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.client.protocol.response.Call;
import org.fisco.bcos.sdk.v3.codec.ContractCodec;
import org.fisco.bcos.sdk.v3.codec.ContractCodecException;
import org.fisco.bcos.sdk.v3.codec.EventEncoder;
import org.fisco.bcos.sdk.v3.codec.EventValues;
import org.fisco.bcos.sdk.v3.codec.FunctionEncoderInterface;
import org.fisco.bcos.sdk.v3.codec.FunctionReturnDecoderInterface;
import org.fisco.bcos.sdk.v3.codec.datatypes.Address;
import org.fisco.bcos.sdk.v3.codec.datatypes.Event;
import org.fisco.bcos.sdk.v3.codec.datatypes.Function;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.scale.FunctionEncoder;
import org.fisco.bcos.sdk.v3.codec.scale.FunctionReturnDecoder;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.TransactionReceiptStatus;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.manager.TransactionProcessor;
import org.fisco.bcos.sdk.v3.transaction.manager.TransactionProcessorFactory;
import org.fisco.bcos.sdk.v3.transaction.model.dto.CallRequest;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Contract {
    protected static Logger logger = LoggerFactory.getLogger(Contract.class);
    protected final String contractBinary;
    protected String contractAddress;
    protected TransactionReceipt deployReceipt;
    protected final TransactionProcessor transactionProcessor;
    protected final Client client;
    public static final String FUNC_DEPLOY = "deploy";
    protected final FunctionEncoderInterface functionEncoder;
    protected final FunctionReturnDecoderInterface functionReturnDecoder;
    protected final CryptoKeyPair credential;
    protected final CryptoSuite cryptoSuite;
    protected final EventEncoder eventEncoder;
    private boolean enableDAG = false;

    protected Contract(String contractBinary, String contractAddress, Client client, CryptoKeyPair credential, TransactionProcessor transactionProcessor) {
        this.contractBinary = contractBinary;
        this.contractAddress = contractAddress;
        this.client = client;
        this.transactionProcessor = transactionProcessor;
        this.credential = credential;
        this.cryptoSuite = client.getCryptoSuite();
        this.functionEncoder = client.isWASM() != false ? new FunctionEncoder(this.cryptoSuite) : new org.fisco.bcos.sdk.v3.codec.abi.FunctionEncoder(this.cryptoSuite);
        this.functionReturnDecoder = client.isWASM() != false ? new FunctionReturnDecoder() : new org.fisco.bcos.sdk.v3.codec.abi.FunctionReturnDecoder();
        this.eventEncoder = new EventEncoder(this.cryptoSuite);
    }

    protected Contract(String contractBinary, String contractAddress, Client client, CryptoKeyPair credential) {
        this(contractBinary, contractAddress, client, credential, TransactionProcessorFactory.createTransactionProcessor(client, credential));
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public TransactionReceipt getDeployReceipt() {
        return this.deployReceipt;
    }

    public void setDeployReceipt(TransactionReceipt deployReceipt) {
        this.deployReceipt = deployReceipt;
    }

    public TransactionProcessor getTransactionProcessor() {
        return this.transactionProcessor;
    }

    public String getCurrentExternalAccountAddress() {
        return this.credential.getAddress();
    }

    public boolean isEnableDAG() {
        return this.enableDAG;
    }

    public void setEnableDAG(boolean enableDAG) {
        this.enableDAG = enableDAG;
    }

    protected static <T extends Contract> T deploy(Class<T> type, Client client, CryptoKeyPair credential, String binary, String abi, byte[] encodedConstructor, String path) throws ContractException {
        try {
            TransactionReceipt transactionReceipt;
            String contractAddress;
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Client.class, CryptoKeyPair.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, client, credential);
            ContractCodec codec = new ContractCodec(contract.cryptoSuite, client.isWASM());
            if (client.isWASM().booleanValue()) {
                contract.setContractAddress(path);
            }
            if ((contractAddress = (transactionReceipt = contract.executeDeployTransaction(codec.encodeConstructorFromBytes(binary, encodedConstructor), abi)).getContractAddress()) == null || transactionReceipt.getStatus() != TransactionReceiptStatus.Success.getCode()) {
                ReceiptParser.getErrorStatus(transactionReceipt);
            }
            contract.setContractAddress(client.isWASM() != false ? path : contractAddress);
            contract.setDeployReceipt(transactionReceipt);
            return (T)contract;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ContractCodecException e) {
            throw new ContractException("deploy contract failed, error info: " + e.getMessage(), e);
        }
    }

    private int generateTransactionAttribute(String funcName) {
        int attribute = 0;
        if (this.client.isWASM().booleanValue()) {
            attribute = 2;
            if (Objects.equals(funcName, FUNC_DEPLOY)) {
                attribute |= 8;
            }
        } else {
            attribute |= 1;
        }
        return attribute;
    }

    private List<Type> executeCall(Function function) throws ContractException {
        byte[] encodedFunctionData = this.functionEncoder.encode(function);
        CallRequest callRequest = new CallRequest(this.credential.getAddress(), this.contractAddress, encodedFunctionData);
        Call response = this.transactionProcessor.executeCall(callRequest);
        String callResult = response.getCallResult().getOutput();
        if (response.getCallResult().getStatus() != 0) {
            ContractException contractException = new ContractException("execute " + function.getName() + " failed for non-zero status " + response.getCallResult().getStatus(), response.getCallResult());
            logger.warn("status of executeCall is non-success, status: {}, callResult: {}", (Object)response.getCallResult().getStatus(), (Object)response.getCallResult());
            throw ReceiptParser.parseExceptionCall(contractException);
        }
        try {
            return this.functionReturnDecoder.decode(callResult, function.getOutputParameters());
        }
        catch (Exception e) {
            throw new ContractException("decode callResult failed, error info: " + e.getMessage(), e, response.getCallResult());
        }
    }

    protected <T extends Type, R> R executeCallWithSingleValueReturn(Function function, Class<R> returnType) throws ContractException {
        List<Type> values = this.executeCall(function);
        if (values.isEmpty()) {
            throw new ContractException("executeCall for function " + function.getName() + " failed for empty returned value from the contract " + this.contractAddress);
        }
        Type result = values.get(0);
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (returnType.isAssignableFrom(result.getClass())) {
            return (R)result;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractException("Unable convert response " + value + " to expected type " + returnType.getSimpleName());
    }

    protected List<Type> executeCallWithMultipleValueReturn(Function function) throws ContractException {
        return this.executeCall(function);
    }

    protected int generateTxAttributeWithDagFlag(String functionName, int dagAttribute) {
        int txAttribute = this.generateTransactionAttribute(functionName);
        int dagFlag = dagAttribute;
        if (this.enableDAG) {
            dagFlag = 4;
        }
        return txAttribute |= dagFlag;
    }

    protected String asyncExecuteTransaction(byte[] data, String funName, TransactionCallback callback, int dagAttribute) {
        int txAttribute = this.generateTxAttributeWithDagFlag(funName, dagAttribute);
        return this.transactionProcessor.sendTransactionAsync(this.contractAddress, data, this.credential, txAttribute, callback);
    }

    protected String asyncExecuteTransaction(Function function, TransactionCallback callback) {
        return this.asyncExecuteTransaction(this.functionEncoder.encode(function), function.getName(), callback, function.getTransactionAttribute());
    }

    protected TransactionReceipt executeTransaction(Function function) {
        int txAttribute = this.generateTxAttributeWithDagFlag(function.getName(), function.getTransactionAttribute());
        return this.transactionProcessor.sendTransactionAndGetReceipt(this.contractAddress, this.functionEncoder.encode(function), this.credential, txAttribute);
    }

    protected TransactionReceipt executeDeployTransaction(byte[] data, String abi) {
        int txAttribute = this.generateTxAttributeWithDagFlag(FUNC_DEPLOY, 0);
        return this.transactionProcessor.deployAndGetReceipt(this.contractAddress, data, abi, this.credential, txAttribute);
    }

    protected String createSignedTransaction(Function function) {
        int txAttribute = this.generateTxAttributeWithDagFlag(function.getName(), function.getTransactionAttribute());
        TxPair txPair = this.transactionProcessor.createSignedTransaction(this.contractAddress, this.functionEncoder.encode(function), this.credential, txAttribute);
        return txPair.getSignedTx();
    }

    public static EventValues staticExtractEventParameters(EventEncoder eventEncoder, FunctionReturnDecoderInterface functionReturnDecoder, Event event, TransactionReceipt.Logs log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = eventEncoder.encode(event);
        if (!topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List<Type> nonIndexedValues = functionReturnDecoder.decode(log.getData(), event.getNonIndexedParameters());
        List<TypeReference<Type>> indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = functionReturnDecoder.decodeIndexedValue(topics.get(i + 1), indexedParameters.get(i));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, TransactionReceipt.Logs log) {
        return Contract.staticExtractEventParameters(this.eventEncoder, this.functionReturnDecoder, event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogEntries().stream().map(log -> this.extractEventParameters(event, (TransactionReceipt.Logs)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, TransactionReceipt.Logs log) {
        EventValues eventValues = this.extractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogEntries().stream().map(log -> this.extractEventParametersWithLog(event, (TransactionReceipt.Logs)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, List<TransactionReceipt.Logs> logs) {
        return logs.stream().map(log -> this.extractEventParametersWithLog(event, (TransactionReceipt.Logs)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList out = new ArrayList();
        for (Type s : arr) {
            out.add(s.getValue());
        }
        return out;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final TransactionReceipt.Logs log;

        private EventValuesWithLog(EventValues eventValues, TransactionReceipt.Logs log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public TransactionReceipt.Logs getLog() {
            return this.log;
        }
    }
}

