/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.crud;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.codec.datatypes.Bool;
import org.fisco.bcos.sdk.v3.codec.datatypes.Function;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.Int32;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple1;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.v3.contract.Contract;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.v3.utils.StringUtils;

public class KVTablePrecompiled
extends Contract {
    public static final String[] BINARY_ARRAY = new String[0];
    public static final String BINARY = StringUtils.joinAll("", BINARY_ARRAY);
    public static final String[] SM_BINARY_ARRAY = new String[0];
    public static final String SM_BINARY = StringUtils.joinAll("", SM_BINARY_ARRAY);
    public static final String[] ABI_ARRAY = new String[]{"[{\"inputs\":[{\"internalType\":\"string\",\"name\":\"key\",\"type\":\"string\"}],\"name\":\"get\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"},{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"selector\":[1765722206,2065403395],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"key\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"value\",\"type\":\"string\"}],\"name\":\"set\",\"outputs\":[{\"internalType\":\"int32\",\"name\":\"\",\"type\":\"int32\"}],\"selector\":[3913463062,439950516],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]"};
    public static final String ABI = StringUtils.joinAll("", ABI_ARRAY);
    public static final String FUNC_GET = "get";
    public static final String FUNC_SET = "set";

    protected KVTablePrecompiled(String contractAddress, Client client, CryptoKeyPair credential) {
        super(KVTablePrecompiled.getBinary(client.getCryptoSuite()), contractAddress, client, credential);
    }

    public static String getBinary(CryptoSuite cryptoSuite) {
        return cryptoSuite.getCryptoTypeConfig() == 0 ? BINARY : SM_BINARY;
    }

    public static String getABI() {
        return ABI;
    }

    public Tuple2<Boolean, String> get(String key) throws ContractException {
        Function function = new Function(FUNC_GET, Arrays.asList(new Utf8String(key)), Arrays.asList(new TypeReference<Bool>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = this.executeCallWithMultipleValueReturn(function);
        return new Tuple2<Boolean, String>((Boolean)results.get(0).getValue(), (String)results.get(1).getValue());
    }

    public TransactionReceipt set(String key, String value) {
        Function function = new Function(FUNC_SET, Arrays.asList(new Utf8String(key), new Utf8String(value)), Collections.emptyList(), 0);
        return this.executeTransaction(function);
    }

    public String set(String key, String value, TransactionCallback callback) {
        Function function = new Function(FUNC_SET, Arrays.asList(new Utf8String(key), new Utf8String(value)), Collections.emptyList(), 0);
        return this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForSet(String key, String value) {
        Function function = new Function(FUNC_SET, Arrays.asList(new Utf8String(key), new Utf8String(value)), Collections.emptyList(), 0);
        return this.createSignedTransaction(function);
    }

    public Tuple2<String, String> getSetInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_SET, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = this.functionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, String>((String)results.get(0).getValue(), (String)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getSetOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_SET, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int32>(){}));
        List<Type> results = this.functionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public static KVTablePrecompiled load(String contractAddress, Client client, CryptoKeyPair credential) {
        return new KVTablePrecompiled(contractAddress, client, credential);
    }
}

