/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.crud.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.sdk.v3.contract.precompiled.crud.TablePrecompiled;

public class Entry {
    private String key;
    private Map<String, String> fieldNameToValue = new LinkedHashMap<String, String>();

    public Entry(List<String> valueColumns, String key, Map<String, String> fieldNameToValue) {
        this.key = key;
        for (String column : valueColumns) {
            this.fieldNameToValue.put(column, fieldNameToValue.get(column));
        }
    }

    public Entry(List<String> valueColumns, TablePrecompiled.Entry entry) {
        this.key = entry.key;
        for (int i = 0; i < valueColumns.size(); ++i) {
            this.fieldNameToValue.put(valueColumns.get(i), entry.fields.get(i));
        }
    }

    public TablePrecompiled.Entry covertToEntry() {
        ArrayList<String> values = new ArrayList<String>(this.fieldNameToValue.values());
        return new TablePrecompiled.Entry(this.key, (List<String>)values);
    }

    public void setFieldNameToValue(Map<String, String> fieldNameToValue) {
        this.fieldNameToValue = fieldNameToValue;
    }

    public Map<String, String> getFieldNameToValue() {
        return this.fieldNameToValue;
    }

    public void putFieldNameToValue(String key, String value) {
        this.fieldNameToValue.put(key, value);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return "Entry{key='" + this.key + '\'' + ", fieldNameToValue=" + this.fieldNameToValue + '}';
    }
}

