/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.contract.precompiled.model;

import org.fisco.bcos.sdk.v3.model.EnumNodeVersion;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;

public class Version {
    private final String minVersion;
    private String maxVersion;
    private String interfaceName;

    public Version(String interfaceName, String minVersion) {
        this.interfaceName = interfaceName;
        this.minVersion = minVersion;
    }

    public Version(String interfaceName, String minVersion, String maxVersion) {
        this.interfaceName = interfaceName;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public void checkVersion(long currentVersion) throws ContractException {
        EnumNodeVersion.Version minSupportVersion = EnumNodeVersion.getClassVersion(this.minVersion);
        EnumNodeVersion.Version supportedVersion = EnumNodeVersion.valueOf((int)currentVersion).toVersionObj();
        String errorMessage = "The fisco bcos node with supported_version lower than " + minSupportVersion.toVersionString() + " does not support the interface " + this.interfaceName + ", current fisco-bcos supported_version:" + supportedVersion.toVersionString();
        if (supportedVersion.compareTo(minSupportVersion) < 0) {
            throw new ContractException(errorMessage);
        }
        if (this.maxVersion == null || this.maxVersion.equals("")) {
            return;
        }
        EnumNodeVersion.Version maxSupportedVersion = EnumNodeVersion.getClassVersion(this.maxVersion);
        errorMessage = "The fisco bcos node with supported_version larger than " + maxSupportedVersion.toVersionString() + " does not support the interface " + this.interfaceName + ", current fisco-bcos supported_version:" + supportedVersion.toVersionString();
        if (supportedVersion.compareTo(maxSupportedVersion) > 0) {
            throw new ContractException(errorMessage);
        }
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }
}

