/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.keypair;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.utilities.keypair.KeyPairJniObj;
import org.fisco.bcos.sdk.v3.crypto.hash.Hash;
import org.fisco.bcos.sdk.v3.crypto.hash.Keccak256;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.keypair.SM2KeyPair;
import org.fisco.bcos.sdk.v3.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSAKeyPair
extends CryptoKeyPair {
    private static final Logger logger = LoggerFactory.getLogger(SM2KeyPair.class);
    public static Hash DefaultHashAlgorithm = new Keccak256();

    public ECDSAKeyPair() {
        this.initECDSAKeyPair();
        CryptoKeyPair keyPair = this.generateKeyPair();
        this.hexPrivateKey = keyPair.getHexPrivateKey();
        this.hexPublicKey = keyPair.getHexPublicKey();
        this.keyPair = KeyTool.convertHexedStringToKeyPair(this.hexPrivateKey, this.curveName);
        this.initJniKeyPair();
    }

    public ECDSAKeyPair(KeyPair javaKeyPair) {
        super(javaKeyPair);
        this.initECDSAKeyPair();
        this.initJniKeyPair();
    }

    protected ECDSAKeyPair(CryptoResult ecKeyPairInfo) {
        super(ecKeyPairInfo);
        this.initECDSAKeyPair();
        this.keyPair = KeyTool.convertHexedStringToKeyPair(this.hexPrivateKey, this.curveName);
        this.initJniKeyPair();
    }

    private void initECDSAKeyPair() {
        this.hashImpl = new Keccak256();
        this.curveName = "secp256k1";
        this.keyStoreSubDir = "ecdsa";
        this.signatureAlgorithm = "SHA256WITHECDSA";
    }

    private void initJniKeyPair() {
        try {
            this.jniKeyPair = KeyPairJniObj.createJniKeyPair((int)0, (byte[])Hex.decode(this.hexPrivateKey));
        }
        catch (JniException e) {
            logger.error("jni e: ", (Throwable)e);
        }
    }

    public static CryptoKeyPair createKeyPair() {
        return new ECDSAKeyPair(NativeInterface.secp256k1GenKeyPair());
    }

    @Override
    public CryptoKeyPair generateKeyPair() {
        return new ECDSAKeyPair(NativeInterface.secp256k1GenKeyPair());
    }

    @Override
    public CryptoKeyPair createKeyPair(KeyPair javaKeyPair) {
        return new ECDSAKeyPair(javaKeyPair);
    }

    public static String getAddressByPublicKey(String publicKey) {
        return ECDSAKeyPair.getAddress(publicKey, DefaultHashAlgorithm);
    }

    public static byte[] getAddressByPublicKey(byte[] publicKey) {
        return Hex.decode(Numeric.cleanHexPrefix(ECDSAKeyPair.getAddressByPublicKey(Hex.toHexString(publicKey))));
    }

    public static byte[] getAddressByPublicKey(BigInteger publicKey) {
        byte[] publicKeyBytes = Numeric.toBytesPadded(publicKey, 64);
        return ECDSAKeyPair.getAddressByPublicKey(publicKeyBytes);
    }
}

