/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.crypto.keystore;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Enumeration;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.fisco.bcos.sdk.v3.crypto.exceptions.LoadKeyStoreException;
import org.fisco.bcos.sdk.v3.crypto.exceptions.SaveKeyStoreException;
import org.fisco.bcos.sdk.v3.crypto.keystore.KeyTool;

public class P12KeyStore
extends KeyTool {
    private static final String NAME = "key";
    private KeyStore keyStore;

    public P12KeyStore(String keyStoreFile, String password) {
        super(keyStoreFile, password);
    }

    public P12KeyStore(InputStream keyStoreFileInputStream, String password) {
        super(keyStoreFileInputStream, password);
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            Certificate certificate = null;
            while (aliases.hasMoreElements() && certificate == null) {
                certificate = this.keyStore.getCertificate(aliases.nextElement());
            }
            if (certificate == null) {
                throw new LoadKeyStoreException("getPublicKey from p12 file " + this.keyStoreFile + "failed");
            }
            return certificate.getPublicKey();
        }
        catch (KeyStoreException e) {
            throw new LoadKeyStoreException("getPublicKey from p12 file " + this.keyStoreFile + " failed, error message: " + e.getMessage(), e);
        }
    }

    @Override
    protected void load(InputStream in) {
        try {
            this.keyStore = KeyStore.getInstance("PKCS12", "BC");
            String password = "";
            if (this.password != null) {
                password = this.password;
            }
            this.keyStore.load(in, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            String errorMessage = "load keys from p12 file " + this.keyStoreFile + " failed, error message:" + e.getMessage();
            logger.error(errorMessage);
            throw new LoadKeyStoreException(errorMessage, e);
        }
    }

    @Override
    protected PrivateKey getPrivateKey() {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            PrivateKey privateKey = null;
            while (aliases.hasMoreElements() && privateKey == null) {
                privateKey = (PrivateKey)this.keyStore.getKey(aliases.nextElement(), this.password.toCharArray());
            }
            if (privateKey == null) {
                throw new LoadKeyStoreException("getPrivateKey from p12 file " + this.keyStoreFile + "failed");
            }
            return privateKey;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            String errorMessage = "get private key from " + this.keyStoreFile + " failed for UnrecoverableKeyException, error message" + e.getMessage();
            logger.error(errorMessage);
            throw new LoadKeyStoreException(errorMessage, e);
        }
    }

    public static void storeKeyPairWithP12Format(String hexedPrivateKey, String password, String privateKeyFilePath, String curveName, String signatureAlgorithm) throws SaveKeyStoreException {
        try {
            PrivateKey privateKey = P12KeyStore.convertHexedStringToPrivateKey(hexedPrivateKey, curveName);
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(null, password.toCharArray());
            KeyPair keyPair = new KeyPair(P12KeyStore.getPublicKeyFromPrivateKey(privateKey), privateKey);
            Certificate[] certChain = new Certificate[]{P12KeyStore.generateSelfSignedCertificate(keyPair, signatureAlgorithm)};
            keyStore.setKeyEntry(NAME, privateKey, password.toCharArray(), certChain);
            FileOutputStream fileOutputStream = new FileOutputStream(privateKeyFilePath);
            keyStore.store(fileOutputStream, password.toCharArray());
            P12KeyStore.storePublicKeyWithPem(privateKey, privateKeyFilePath);
            fileOutputStream.close();
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException | LoadKeyStoreException e) {
            throw new SaveKeyStoreException("save private key into " + privateKeyFilePath + " failed, error information: " + e.getMessage(), e);
        }
    }

    public static X509Certificate generateSelfSignedCertificate(KeyPair keyPair, String signatureAlgorithm) throws NoSuchAlgorithmException, CertificateEncodingException, NoSuchProviderException, InvalidKeyException, SignatureException {
        X509V3CertificateGenerator cert = new X509V3CertificateGenerator();
        cert.setSerialNumber(BigInteger.valueOf(1L));
        cert.setSubjectDN((X509Name)new X509Principal("CN=localhost"));
        cert.setIssuerDN((X509Name)new X509Principal("CN=localhost"));
        cert.setPublicKey(keyPair.getPublic());
        Calendar notBefore = Calendar.getInstance();
        Calendar notAfter = Calendar.getInstance();
        notBefore.add(1, 100);
        cert.setNotBefore(notBefore.getTime());
        cert.setNotAfter(notAfter.getTime());
        cert.setSignatureAlgorithm(signatureAlgorithm);
        cert.setPublicKey(keyPair.getPublic());
        PrivateKey signingKey = keyPair.getPrivate();
        return cert.generate(signingKey, "BC");
    }
}

