/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.eventsub;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.abi.tools.TopicTools;
import org.fisco.bcos.sdk.v3.utils.AddressUtils;

public class EventSubParams {
    private BigInteger fromBlock = BigInteger.valueOf(-1L);
    private BigInteger toBlock = BigInteger.valueOf(-1L);
    private final List<String> addresses = new ArrayList<String>();
    private final List<List<String>> topics = new ArrayList<List>(Arrays.asList(null, null, null, null));

    public BigInteger getFromBlock() {
        return this.fromBlock;
    }

    public void setFromBlock(BigInteger fromBlock) {
        this.fromBlock = fromBlock;
    }

    public BigInteger getToBlock() {
        return this.toBlock;
    }

    public void setToBlock(BigInteger toBlock) {
        this.toBlock = toBlock;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public List<List<String>> getTopics() {
        return this.topics;
    }

    public boolean addAddress(String addr) {
        if (!AddressUtils.isValidAddress(addr)) {
            return false;
        }
        return this.addresses.add(addr);
    }

    public boolean addTopic(int index, String topic) {
        if (!TopicTools.validTopic(topic)) {
            return false;
        }
        if (index >= 4) {
            return false;
        }
        List<String> strings = this.topics.get(index);
        if (strings == null) {
            strings = new ArrayList<String>();
            this.topics.set(index, strings);
        }
        strings.add(topic);
        return true;
    }

    public boolean checkParams() {
        if (this.fromBlock.compareTo(BigInteger.ZERO) > 0 && this.toBlock.compareTo(BigInteger.ZERO) > 0) {
            return this.fromBlock.compareTo(this.toBlock) <= 0;
        }
        return true;
    }

    public String toString() {
        return "EventLogParams{fromBlock=" + this.fromBlock + ", toBlock=" + this.toBlock + ", addresses=" + this.addresses + ", topics=" + this.topics + '}';
    }
}

