/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.model;

import java.util.HashMap;
import java.util.Map;

public enum EnumNodeVersion {
    UNKNOWN(-1),
    BCOS_3_0_0_RC4(4),
    BCOS_3_0_0(0x3000000),
    BCOS_3_1_0(0x3010000),
    BCOS_3_2_0(0x3020000);

    private final Integer version;
    private static final Map<Integer, EnumNodeVersion> versionLookupMap;

    private EnumNodeVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getVersionString() {
        switch (this) {
            case BCOS_3_0_0_RC4: {
                return "3.0.0-rc4";
            }
            case BCOS_3_0_0: {
                return "3.0.0";
            }
            case BCOS_3_1_0: {
                return "3.1.0";
            }
            case BCOS_3_2_0: {
                return "3.2.0";
            }
        }
        return "0.0.0";
    }

    public Version toVersionObj() {
        return EnumNodeVersion.getClassVersion(this.getVersionString());
    }

    public static EnumNodeVersion valueOf(int version) {
        EnumNodeVersion enumNodeVersion = versionLookupMap.get(version);
        if (enumNodeVersion == null) {
            return UNKNOWN;
        }
        return enumNodeVersion;
    }

    public static Version convertToVersion(int version) {
        return EnumNodeVersion.valueOf(version).toVersionObj();
    }

    public static Version getClassVersion(String version) {
        String[] s1;
        String[] s0 = version.trim().split("-");
        Version v = new Version();
        if (s0.length > 1) {
            v.setExt(s0[1]);
        }
        if ((s1 = s0[0].split("\\.")).length < 3) {
            throw new IllegalStateException(" invalid node version format, version: " + version);
        }
        v.setMajor(Integer.parseInt(s1[0].trim()));
        v.setMinor(Integer.parseInt(s1[1].trim()));
        v.setPatch(Integer.parseInt(s1[2].trim()));
        return v;
    }

    static {
        versionLookupMap = new HashMap<Integer, EnumNodeVersion>();
        versionLookupMap.put(4, BCOS_3_0_0_RC4);
        versionLookupMap.put(0x3000000, BCOS_3_0_0);
        versionLookupMap.put(0x3010000, BCOS_3_1_0);
        versionLookupMap.put(0x3020000, BCOS_3_2_0);
    }

    public static class Version
    implements Comparable<Version> {
        private int major;
        private int minor;
        private int patch;
        private String ext = "";

        public String toString() {
            return "Version [major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", ext=" + this.ext + "]";
        }

        public String toVersionString() {
            String str = this.getMajor() + "." + this.getMinor() + "." + this.getPatch();
            if (this.ext != null && !this.ext.isEmpty()) {
                str = str + "-" + this.ext;
            }
            return str;
        }

        public int getMajor() {
            return this.major;
        }

        public void setMajor(int major) {
            this.major = major;
        }

        public int getMinor() {
            return this.minor;
        }

        public void setMinor(int minor) {
            this.minor = minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public void setPatch(int patch) {
            this.patch = patch;
        }

        public String getExt() {
            return this.ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        @Override
        public int compareTo(Version v) {
            int vCompactVersion;
            int thisCompactVersion = this.getMajor() * 100 + this.getMinor() * 10 + this.getPatch();
            if (thisCompactVersion > (vCompactVersion = v.getMajor() * 100 + v.getMinor() * 10 + v.getPatch())) {
                return 1;
            }
            if (thisCompactVersion < vCompactVersion) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((Version)obj) == 0;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

