/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.v3.utils.Numeric;

public class EventLog {
    private String logIndex;
    private String transactionIndex;
    private String transactionHash;
    private String blockNumber;
    private String address;
    private String data;
    private List<String> topics;

    public EventLog() {
    }

    public EventLog(String logIndex, String transactionIndex, String transactionHash, String blockNumber, String address, String data, List<String> topics) {
        this.logIndex = logIndex;
        this.transactionIndex = transactionIndex;
        this.transactionHash = transactionHash;
        this.blockNumber = blockNumber;
        this.address = address;
        this.data = data;
        this.topics = topics;
    }

    public EventLog(String data, List<String> topics) {
        this.data = data;
        this.topics = topics;
    }

    public BigInteger getLogIndex() {
        return this.convert(this.logIndex);
    }

    @JsonIgnore
    public String getLogIndexRaw() {
        return this.logIndex;
    }

    public void setLogIndex(String logIndex) {
        this.logIndex = logIndex;
    }

    public BigInteger getTransactionIndex() {
        return this.convert(this.transactionIndex);
    }

    @JsonIgnore
    public String getTransactionIndexRaw() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public BigInteger getBlockNumber() {
        return this.convert(this.blockNumber);
    }

    @JsonIgnore
    public String getBlockNumberRaw() {
        return this.blockNumber;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    private BigInteger convert(String value) {
        if (value != null) {
            return Numeric.decodeQuantity(value);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventLog)) {
            return false;
        }
        EventLog log = (EventLog)o;
        if (this.getLogIndexRaw() != null ? !this.getLogIndexRaw().equals(log.getLogIndexRaw()) : log.getLogIndexRaw() != null) {
            return false;
        }
        if (this.getTransactionIndexRaw() != null ? !this.getTransactionIndexRaw().equals(log.getTransactionIndexRaw()) : log.getTransactionIndexRaw() != null) {
            return false;
        }
        if (this.getTransactionHash() != null ? !this.getTransactionHash().equals(log.getTransactionHash()) : log.getTransactionHash() != null) {
            return false;
        }
        if (this.getBlockNumberRaw() != null ? !this.getBlockNumberRaw().equals(log.getBlockNumberRaw()) : log.getBlockNumberRaw() != null) {
            return false;
        }
        if (this.getAddress() != null ? !this.getAddress().equals(log.getAddress()) : log.getAddress() != null) {
            return false;
        }
        if (this.getData() != null ? !this.getData().equals(log.getData()) : log.getData() != null) {
            return false;
        }
        return this.getTopics() != null ? this.getTopics().equals(log.getTopics()) : log.getTopics() == null;
    }

    public int hashCode() {
        return Objects.hash(this.logIndex, this.transactionIndex, this.transactionHash, this.blockNumber, this.address, this.data, this.topics);
    }

    public String toString() {
        return "EventLog{logIndex='" + this.logIndex + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", transactionHash='" + this.transactionHash + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", address='" + this.address + '\'' + ", data='" + this.data + '\'' + ", topics=" + this.topics + '}';
    }
}

