/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.fisco.bcos.sdk.v3.model.RetCode;

public class PrecompiledRetCode {
    public static final RetCode CODE_ADDRESS_OR_VERSION_ERROR;
    public static final RetCode CODE_VERSION_LENGTH_OVERFLOW;
    public static final RetCode CODE_FILE_INVALID_PATH;
    public static final RetCode CODE_FILE_SET_WASM_FAILED;
    public static final RetCode CODE_FILE_BUILD_DIR_FAILED;
    public static final RetCode CODE_FILE_ALREADY_EXIST;
    public static final RetCode CODE_FILE_NOT_EXIST;
    public static final RetCode CODE_CURRENT_VALUE_IS_EXPECTED_VALUE;
    public static final RetCode CODE_ACCOUNT_FROZEN;
    public static final RetCode CODE_ACCOUNT_ALREADY_AVAILABLE;
    public static final RetCode CODE_INVALID_ACCOUNT_ADDRESS;
    public static final RetCode CODE_ACCOUNT_NOT_EXIST;
    public static final RetCode CODE_OPERATOR_NOT_EXIST;
    public static final RetCode CODE_OPERATOR_EXIST;
    public static final RetCode CODE_COMMITTEE_MEMBER_CANNOT_BE_OPERATOR;
    public static final RetCode CODE_OPERATOR_CANNOT_BE_COMMITTEE_MEMBER;
    public static final RetCode CODE_INVALID_THRESHOLD;
    public static final RetCode CODE_INVALID_REQUEST_PERMISSION_DENIED;
    public static final RetCode CODE_COMMITTEE_MEMBER_NOT_EXIST;
    public static final RetCode CODE_COMMITTEE_MEMBER_EXIST;
    public static final RetCode CODE_INVALID_REVOKE_LAST_AUTHORIZATION;
    public static final RetCode CODE_INVALID_NON_EXIST_AUTHORIZATION;
    public static final RetCode CODE_INVALID_NO_AUTHORIZED;
    public static final RetCode CODE_INVALID_TABLE_NOT_EXIST;
    public static final RetCode CODE_INVALID_CONTRACT_ADDRESS;
    public static final RetCode CODE_INVALID_CONTRACT_REPEAT_AUTHORIZATION;
    public static final RetCode CODE_INVALID_CONTRACT_AVAILABLE;
    public static final RetCode CODE_ACCOUNT_ALREADY_EXIST;
    public static final RetCode VERIFY_RING_SIG_FAILED;
    public static final RetCode VERIFY_GROUP_SIG_FAILED;
    public static final RetCode CODE_INVALID_CIPHERS;
    public static final RetCode CODE_REMOVE_KEY_NOT_EXIST;
    public static final RetCode CODE_UPDATE_KEY_NOT_EXIST;
    public static final RetCode CODE_INSERT_KEY_EXIST;
    public static final RetCode CODE_KEY_NOT_EXIST_IN_COND;
    public static final RetCode CODE_KEY_NOT_EXIST_IN_ENTRY;
    public static final RetCode CODE_INVALID_UPDATE_TABLE_KEY;
    public static final RetCode CODE_CONDITION_OPERATION_UNDEFINED;
    public static final RetCode CODE_PARSE_CONDITION_ERROR;
    public static final RetCode CODE_PARSE_ENTRY_ERROR;
    public static final RetCode CODE_INVALID_CONFIGURATION_VALUES;
    public static final RetCode CODE_ADD_SEALER_SHOULD_IN_OBSERVER;
    public static final RetCode CODE_NODE_NOT_EXIST;
    public static final RetCode CODE_INVALID_WEIGHT;
    public static final RetCode CODE_LAST_SEALER;
    public static final RetCode CODE_INVALID_NODEID;
    public static final RetCode CODE_TABLE_AUTH_TYPE_DECODE_ERROR;
    public static final RetCode CODE_TABLE_ERROR_AUTH_TYPE;
    public static final RetCode CODE_TABLE_AUTH_TYPE_NOT_EXIST;
    public static final RetCode CODE_TABLE_AUTH_ROW_NOT_EXIST;
    public static final RetCode CODE_TABLE_AGENT_ROW_NOT_EXIST;
    public static final RetCode CODE_TABLE_OPEN_ERROR;
    public static final RetCode CODE_TABLE_CREATE_ERROR;
    public static final RetCode CODE_TABLE_SET_ROW_ERROR;
    public static final RetCode CODE_ADDRESS_INVALID;
    public static final RetCode CODE_UNKNOWN_FUNCTION_CALL;
    public static final RetCode CODE_TABLE_NOT_EXIST;
    public static final RetCode CODE_SUCCESS;
    public static final RetCode CODE_UNKNOWN_FAILED;
    public static final RetCode CODE_NO_AUTHORIZED;
    public static final RetCode CODE_TABLE_NAME_ALREADY_EXIST;
    public static final RetCode CODE_TABLE_NAME_LENGTH_OVERFLOW;
    public static final RetCode CODE_TABLE_FILED_LENGTH_OVERFLOW;
    public static final RetCode CODE_TABLE_FILED_TOTALLENGTH_OVERFLOW;
    public static final RetCode CODE_TABLE_KEYVALUE_LENGTH_OVERFLOW;
    public static final RetCode CODE_TABLE_FIELDVALUE_LENGTH_OVERFLOW;
    public static final RetCode CODE_TABLE_DUMPLICATE_FIELD;
    public static final RetCode CODE_TABLE_INVALIDATE_FIELD;
    public static final String MUST_EXIST_IN_NODE_LIST = "The operated node must be in the list returned by getGroupPeers";
    public static final String ALREADY_EXISTS_IN_SEALER_LIST = "The node already exists in the sealerList";
    public static final String ALREADY_EXISTS_IN_OBSERVER_LIST = "The node already exists in the observerList";
    public static final String ALREADY_REMOVED_FROM_THE_GROUP = "The node already has been removed from the group";
    public static final String OVER_TABLE_KEY_LENGTH_LIMIT = "The length of the table key exceeds the maximum limit 255";
    protected static Map<Integer, RetCode> codeToMessage;

    private PrecompiledRetCode() {
    }

    public static RetCode getPrecompiledResponse(Integer responseCode, String message) {
        if (codeToMessage.containsKey(responseCode)) {
            return codeToMessage.get(responseCode);
        }
        return new RetCode(responseCode, message);
    }

    static {
        Field[] fields;
        CODE_ADDRESS_OR_VERSION_ERROR = new RetCode(-51202, "The contract address or version is invalid");
        CODE_VERSION_LENGTH_OVERFLOW = new RetCode(-51201, "The version string length exceeds the maximum limit");
        CODE_FILE_INVALID_PATH = new RetCode(-53005, "Invalid path");
        CODE_FILE_SET_WASM_FAILED = new RetCode(-53004, "Deploy WASM contract failed");
        CODE_FILE_BUILD_DIR_FAILED = new RetCode(-53003, "Make directory failed");
        CODE_FILE_ALREADY_EXIST = new RetCode(-53002, "File already existed");
        CODE_FILE_NOT_EXIST = new RetCode(-53001, "Path of file not exist");
        CODE_CURRENT_VALUE_IS_EXPECTED_VALUE = new RetCode(-52012, "The current value is expected");
        CODE_ACCOUNT_FROZEN = new RetCode(-52011, "The account is frozen");
        CODE_ACCOUNT_ALREADY_AVAILABLE = new RetCode(-52010, "The account is already available");
        CODE_INVALID_ACCOUNT_ADDRESS = new RetCode(-52009, "Invalid account address");
        CODE_ACCOUNT_NOT_EXIST = new RetCode(-52008, "Account not exist, you can create a blockchain account by using this account to deploy contracts on the chain");
        CODE_OPERATOR_NOT_EXIST = new RetCode(-52007, "The operator not exist");
        CODE_OPERATOR_EXIST = new RetCode(-52006, "The operator already exist");
        CODE_COMMITTEE_MEMBER_CANNOT_BE_OPERATOR = new RetCode(-52005, "The committee member cannot be operator");
        CODE_OPERATOR_CANNOT_BE_COMMITTEE_MEMBER = new RetCode(-52004, "The operator cannot be committee member");
        CODE_INVALID_THRESHOLD = new RetCode(-52003, "Invalid threshold, threshold should from 0 to 99");
        CODE_INVALID_REQUEST_PERMISSION_DENIED = new RetCode(-52002, "Invalid request for permission deny");
        CODE_COMMITTEE_MEMBER_NOT_EXIST = new RetCode(-52001, "The committee member not exist");
        CODE_COMMITTEE_MEMBER_EXIST = new RetCode(-52000, "The committee member already exist");
        CODE_INVALID_REVOKE_LAST_AUTHORIZATION = new RetCode(-51907, "The permission of the last contract status manager can't be revoked");
        CODE_INVALID_NON_EXIST_AUTHORIZATION = new RetCode(-51906, "The contract status manager doesn't exist");
        CODE_INVALID_NO_AUTHORIZED = new RetCode(-51905, "Have no permission to access the contract table");
        CODE_INVALID_TABLE_NOT_EXIST = new RetCode(-51904, "The queried contract address doesn't exist");
        CODE_INVALID_CONTRACT_ADDRESS = new RetCode(-51903, "The contract address is invalid");
        CODE_INVALID_CONTRACT_REPEAT_AUTHORIZATION = new RetCode(-51902, "The contract has been granted authorization with same user");
        CODE_INVALID_CONTRACT_AVAILABLE = new RetCode(-51901, "The contract is available");
        CODE_ACCOUNT_ALREADY_EXIST = new RetCode(-51900, "The account is not a valid account");
        VERIFY_RING_SIG_FAILED = new RetCode(-51800, "Verify ring signature failed");
        VERIFY_GROUP_SIG_FAILED = new RetCode(-51700, "Verify group signature failed");
        CODE_INVALID_CIPHERS = new RetCode(-51600, "Execute PaillierAdd failed");
        CODE_REMOVE_KEY_NOT_EXIST = new RetCode(-51508, "Key not exist in table, please check again");
        CODE_UPDATE_KEY_NOT_EXIST = new RetCode(-51507, "Key not exist in table, use insert method");
        CODE_INSERT_KEY_EXIST = new RetCode(-51506, "Don't insert the key already existed");
        CODE_KEY_NOT_EXIST_IN_COND = new RetCode(-51505, "Add specific table key EQ syntax in condition");
        CODE_KEY_NOT_EXIST_IN_ENTRY = new RetCode(-51504, "Add specific table key in entry");
        CODE_INVALID_UPDATE_TABLE_KEY = new RetCode(-51503, "Don't update the table key");
        CODE_CONDITION_OPERATION_UNDEFINED = new RetCode(-51502, "Undefined function of Condition Precompiled");
        CODE_PARSE_CONDITION_ERROR = new RetCode(-51501, "Parse the input of Condition Precompiled failed");
        CODE_PARSE_ENTRY_ERROR = new RetCode(-51500, "Parse the input of the Entry Precompiled failed");
        CODE_INVALID_CONFIGURATION_VALUES = new RetCode(-51300, "Invalid configuration value");
        CODE_ADD_SEALER_SHOULD_IN_OBSERVER = new RetCode(-51104, "Only observer can be set in sealer");
        CODE_NODE_NOT_EXIST = new RetCode(-51103, "The node is not exist");
        CODE_INVALID_WEIGHT = new RetCode(-51102, "The weight is invalid");
        CODE_LAST_SEALER = new RetCode(-51101, "The last sealer cannot be removed");
        CODE_INVALID_NODEID = new RetCode(-51100, "Invalid node ID");
        CODE_TABLE_AUTH_TYPE_DECODE_ERROR = new RetCode(-51004, "Auth map decode error.");
        CODE_TABLE_ERROR_AUTH_TYPE = new RetCode(-51003, "Error auth type input.");
        CODE_TABLE_AUTH_TYPE_NOT_EXIST = new RetCode(-51002, "The contract method auth type not set, please set method auth type first.");
        CODE_TABLE_AUTH_ROW_NOT_EXIST = new RetCode(-51001, "The contract method auth not exist");
        CODE_TABLE_AGENT_ROW_NOT_EXIST = new RetCode(-51000, "The contract admin not exist");
        CODE_TABLE_OPEN_ERROR = new RetCode(-50105, "Open table error");
        CODE_TABLE_CREATE_ERROR = new RetCode(-50104, "Create table error");
        CODE_TABLE_SET_ROW_ERROR = new RetCode(-50103, "Table set row error");
        CODE_ADDRESS_INVALID = new RetCode(-50102, "Invalid address format");
        CODE_UNKNOWN_FUNCTION_CALL = new RetCode(-50101, "Undefined function");
        CODE_TABLE_NOT_EXIST = new RetCode(-50100, "Open table failed, please check the existence of the table");
        CODE_SUCCESS = new RetCode(0, "Success");
        CODE_UNKNOWN_FAILED = new RetCode(-1, "Unknown failed");
        CODE_NO_AUTHORIZED = new RetCode(-50000, "Permission denied");
        CODE_TABLE_NAME_ALREADY_EXIST = new RetCode(-50001, "The table already exist");
        CODE_TABLE_NAME_LENGTH_OVERFLOW = new RetCode(-50002, "The table name length exceeds the limit 48");
        CODE_TABLE_FILED_LENGTH_OVERFLOW = new RetCode(-50003, "The table field name exceeds the limit 64");
        CODE_TABLE_FILED_TOTALLENGTH_OVERFLOW = new RetCode(-50004, "The length of all the fields name exceeds the limit 1024");
        CODE_TABLE_KEYVALUE_LENGTH_OVERFLOW = new RetCode(-50005, "The value exceeds the limit, key max length is 255, field value max length is 1024");
        CODE_TABLE_FIELDVALUE_LENGTH_OVERFLOW = new RetCode(-50006, "The field value exceeds the limit 1024");
        CODE_TABLE_DUMPLICATE_FIELD = new RetCode(-50007, "The table contains duplicated field");
        CODE_TABLE_INVALIDATE_FIELD = new RetCode(-50008, "Invalid table name or field name");
        codeToMessage = new HashMap<Integer, RetCode>();
        for (Field field : fields = PrecompiledRetCode.class.getDeclaredFields()) {
            if (!field.getType().equals(RetCode.class)) continue;
            try {
                RetCode constantRetCode = (RetCode)field.get(null);
                codeToMessage.put(constantRetCode.getCode(), constantRetCode);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

