/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.utilities.keypair.KeyPairJniObj;
import org.fisco.bcos.sdk.jni.utilities.receipt.ReceiptBuilderJniObj;
import org.fisco.bcos.sdk.v3.client.exceptions.ClientException;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.model.EventLog;
import org.fisco.bcos.sdk.v3.model.MerkleProofUnit;
import org.fisco.bcos.sdk.v3.utils.AddressUtils;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;

public class TransactionReceipt {
    private Integer version;
    private String contractAddress;
    private String checksumContractAddress;
    private String gasUsed;
    private int status = -1;
    private BigInteger blockNumber;
    private String output;
    private String transactionHash;
    @JsonProperty(value="hash")
    private String receiptHash;
    private List<Logs> logEntries;
    private String input;
    private String from;
    private String to;
    @Deprecated
    private List<MerkleProofUnit> transactionProof;
    @Deprecated
    private List<MerkleProofUnit> receiptProof;
    private List<String> txProof;
    private List<String> txReceiptProof;
    private String extraData;
    private String message;

    public boolean isStatusOK() {
        return this.status == 0;
    }

    public static TransactionReceipt readFromHexString(String hexString) throws JniException, IOException {
        String jsonObj = ReceiptBuilderJniObj.decodeReceiptDataToJsonObj((String)hexString);
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (TransactionReceipt)objectMapper.readValue(jsonObj.getBytes(), TransactionReceipt.class);
    }

    public String writeToHexString() throws JsonProcessingException, JniException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this);
        long receiptDataWithJson = ReceiptBuilderJniObj.createReceiptDataWithJson((String)json);
        String encodeReceiptData = ReceiptBuilderJniObj.encodeReceiptData((long)receiptDataWithJson);
        ReceiptBuilderJniObj.destroyReceiptData((long)receiptDataWithJson);
        return encodeReceiptData;
    }

    @Deprecated
    public List<MerkleProofUnit> getReceiptProof() {
        return this.receiptProof;
    }

    @Deprecated
    public void setReceiptProof(List<MerkleProofUnit> receiptProof) {
        this.receiptProof = receiptProof;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getReceiptHash() {
        return this.receiptHash;
    }

    public void setReceiptHash(String receiptHash) {
        this.receiptHash = receiptHash;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return AddressUtils.addHexPrefixToAddress(this.to);
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public String getContractAddress() {
        return AddressUtils.addHexPrefixToAddress(this.contractAddress);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getChecksumContractAddress() {
        return this.checksumContractAddress;
    }

    public void setChecksumContractAddress(String checksumContractAddress) {
        this.checksumContractAddress = checksumContractAddress;
    }

    public void setLogEntries(List<Logs> logEntries) {
        this.logEntries = logEntries;
    }

    public List<Logs> getLogEntries() {
        return this.logEntries;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @Deprecated
    public List<MerkleProofUnit> getTransactionProof() {
        return this.transactionProof;
    }

    @Deprecated
    public void setTransactionProof(List<MerkleProofUnit> transactionProof) {
        this.transactionProof = transactionProof;
    }

    public List<String> getTxProof() {
        return this.txProof;
    }

    public void setTxProof(List<String> txProof) {
        this.txProof = txProof;
    }

    public List<String> getTxReceiptProof() {
        return this.txReceiptProof;
    }

    public void setTxReceiptProof(List<String> txReceiptProof) {
        this.txReceiptProof = txReceiptProof;
    }

    public String calculateReceiptHash(CryptoSuite cryptoSuite) throws ClientException {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            String json = objectMapper.writeValueAsString((Object)this);
            long receiptData = ReceiptBuilderJniObj.createReceiptDataWithJson((String)json);
            long jniKeyPair = cryptoSuite.getCryptoKeyPair().getJniKeyPair();
            int jniKeyPairCryptoType = KeyPairJniObj.getJniKeyPairCryptoType((long)jniKeyPair);
            String receiptDataHash = ReceiptBuilderJniObj.calcReceiptDataHash((int)jniKeyPairCryptoType, (long)receiptData);
            ReceiptBuilderJniObj.destroyReceiptData((long)receiptData);
            return receiptDataHash;
        }
        catch (Exception e) {
            throw new ClientException("calculate hash for receipt " + this.receiptHash + " failed for " + e.getMessage(), e);
        }
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionReceipt that = (TransactionReceipt)o;
        return Objects.equals(this.transactionHash, that.transactionHash) && Objects.equals(this.version, that.version) && Objects.equals(this.blockNumber, that.blockNumber) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.gasUsed, that.gasUsed) && Objects.equals(this.contractAddress, that.contractAddress) && Objects.equals(this.checksumContractAddress, that.checksumContractAddress) && Objects.equals(this.logEntries, that.logEntries) && Objects.equals(this.status, that.status) && Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output) && Objects.equals(this.extraData, that.extraData) && Objects.equals(this.transactionProof, that.transactionProof) && Objects.equals(this.receiptProof, that.receiptProof);
    }

    public int hashCode() {
        return Objects.hash(this.transactionHash, this.version, this.blockNumber, this.from, this.to, this.gasUsed, this.contractAddress, this.checksumContractAddress, this.logEntries, this.status, this.input, this.output, this.extraData, this.transactionProof, this.receiptProof);
    }

    public String toString() {
        return "TransactionReceipt{transactionHash='" + this.transactionHash + '\'' + ", version='" + this.version + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", from='" + this.from + '\'' + ", to='" + this.getTo() + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", contractAddress='" + this.contractAddress + ", checksumContractAddress='" + this.checksumContractAddress + '\'' + ", logs=" + this.logEntries + ", status='" + this.status + '\'' + ", extraData='" + this.extraData + '\'' + ", input='" + this.input + '\'' + ", output='" + this.output + '\'' + ", txProof=" + this.txProof + ", txReceiptProof=" + this.txReceiptProof + '}';
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class Logs {
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="topics")
        private List<String> topics;
        @JsonProperty(value="data")
        private String data;
        private String blockNumber;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        public EventLog toEventLog() {
            EventLog eventLog = new EventLog();
            eventLog.setAddress(this.address);
            eventLog.setTopics(this.topics);
            eventLog.setData(this.data);
            eventLog.setBlockNumber(this.blockNumber);
            return eventLog;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Logs logs = (Logs)o;
            return Objects.equals(this.address, logs.address) && Objects.equals(this.topics, logs.topics) && Objects.equals(this.data, logs.data);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.topics, this.data);
        }

        public String toString() {
            return "Logs{address='" + this.address + '\'' + ", topics=" + this.topics + ", data='" + this.data + '\'' + '}';
        }
    }
}

