/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.codec.decode;

import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.v3.codec.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.v3.codec.datatypes.Function;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevertMessageParser {
    private static final Logger logger = LoggerFactory.getLogger(RevertMessageParser.class);
    public static final String REVERT_METHOD = "08c379a0";
    public static final String SM_REVERT_METHOD = "c703cb12";
    public static final Function revertFunction = new Function("Error", Collections.emptyList(), Collections.singletonList(new TypeReference<Utf8String>(){}));

    private RevertMessageParser() {
    }

    public static boolean isOutputStartWithRevertMethod(String output) {
        String trimPrefix = Hex.trimPrefix(output);
        return trimPrefix.startsWith(REVERT_METHOD) || trimPrefix.startsWith(SM_REVERT_METHOD);
    }

    public static boolean hasRevertMessage(Integer status, String output) {
        if (StringUtils.isEmpty(output)) {
            return false;
        }
        return status != 0 && RevertMessageParser.isOutputStartWithRevertMethod(output);
    }

    public static Tuple2<Boolean, String> tryResolveRevertMessage(Integer status, String output) {
        if (!RevertMessageParser.hasRevertMessage(status, output)) {
            return new Tuple2<Boolean, Object>(false, null);
        }
        try {
            String rawOutput = Hex.trimPrefix(output).substring(REVERT_METHOD.length());
            FunctionReturnDecoder functionReturnDecoder = new FunctionReturnDecoder();
            List<Type> result = functionReturnDecoder.decode(rawOutput, revertFunction.getOutputParameters());
            if (result.get(0) instanceof Utf8String) {
                String message = ((Utf8String)result.get(0)).getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug(" ABI: {} , RevertMessage: {}", (Object)output, (Object)message);
                }
                return new Tuple2<Boolean, String>(true, message);
            }
        }
        catch (Exception e) {
            logger.warn(" ABI: {}, e: ", (Object)output, (Object)e);
        }
        return new Tuple2<Boolean, Object>(false, null);
    }

    public static Tuple2<Boolean, String> tryResolveRevertMessage(TransactionReceipt receipt) {
        return RevertMessageParser.tryResolveRevertMessage(receipt.getStatus(), receipt.getOutput());
    }
}

