/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.codec.decode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fisco.bcos.sdk.v3.codec.ContractCodec;
import org.fisco.bcos.sdk.v3.codec.ContractCodecException;
import org.fisco.bcos.sdk.v3.codec.EventEncoder;
import org.fisco.bcos.sdk.v3.codec.Utils;
import org.fisco.bcos.sdk.v3.codec.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinitionFactory;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIObject;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIObjectFactory;
import org.fisco.bcos.sdk.v3.codec.wrapper.ContractABIDefinition;
import org.fisco.bcos.sdk.v3.codec.wrapper.ContractCodecTools;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.TransactionDecoderInterface;
import org.fisco.bcos.sdk.v3.transaction.model.dto.TransactionResponse;
import org.fisco.bcos.sdk.v3.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.v3.transaction.tools.JsonUtils;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionDecoderService
implements TransactionDecoderInterface {
    protected static Logger logger = LoggerFactory.getLogger(TransactionDecoderService.class);
    private CryptoSuite cryptoSuite;
    private final ContractCodec contractCodec;
    private final EventEncoder eventEncoder;

    public TransactionDecoderService(CryptoSuite cryptoSuite, boolean isWasm) {
        this.cryptoSuite = cryptoSuite;
        this.contractCodec = new ContractCodec(cryptoSuite, isWasm);
        this.eventEncoder = new EventEncoder(cryptoSuite);
    }

    @Override
    public String decodeRevertMessage(String output) {
        if ((output = Hex.trimPrefix(output)).length() <= 8) {
            return null;
        }
        FunctionReturnDecoder functionReturnDecoderInterface = new FunctionReturnDecoder();
        List<Type> r = functionReturnDecoderInterface.decode(output.substring(8), Utils.convert(Collections.singletonList(new TypeReference<Utf8String>(){})));
        return r.get(0).toString();
    }

    @Override
    public TransactionResponse decodeReceiptWithValues(String abi, String functionName, TransactionReceipt transactionReceipt) throws ContractCodecException {
        TransactionResponse response = this.decodeReceiptWithoutValues(abi, transactionReceipt);
        if (transactionReceipt.getStatus() == 0) {
            List<Type> results = this.contractCodec.decodeMethodAndGetOutputObject(abi, functionName, transactionReceipt.getOutput());
            response.setResults(results);
        }
        return response;
    }

    @Override
    public TransactionResponse decodeReceiptWithoutValues(String abi, TransactionReceipt transactionReceipt) {
        TransactionResponse response = this.decodeReceiptStatus(transactionReceipt);
        response.setTransactionReceipt(transactionReceipt);
        response.setContractAddress(transactionReceipt.getContractAddress());
        if (transactionReceipt.getStatus() != 0) {
            return response;
        }
        String events = JsonUtils.toJson(this.decodeEvents(abi, transactionReceipt.getLogEntries()));
        response.setEvents(events);
        return response;
    }

    @Override
    public TransactionResponse decodeReceiptStatus(TransactionReceipt receipt) {
        TransactionResponse response = new TransactionResponse();
        try {
            RetCode retCode = ReceiptParser.parseTransactionReceipt(receipt, null);
            response.setReturnCode(retCode.getCode());
            response.setReceiptMessages(retCode.getMessage());
            response.setReturnMessage(retCode.getMessage());
        }
        catch (ContractException e) {
            response.setReturnCode(e.getErrorCode());
            response.setReceiptMessages(e.getMessage());
            response.setReturnMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public Map<String, List<List<Object>>> decodeEvents(String abi, List<TransactionReceipt.Logs> logs) {
        ABIDefinitionFactory abiDefinitionFactory = new ABIDefinitionFactory(this.cryptoSuite);
        ContractABIDefinition contractABIDefinition = abiDefinitionFactory.loadABI(abi);
        Map<String, List<ABIDefinition>> eventsMap = contractABIDefinition.getEvents();
        HashMap<String, List<List<Object>>> result = new HashMap<String, List<List<Object>>>();
        if (logs == null) {
            return result;
        }
        eventsMap.forEach((name, events) -> {
            for (ABIDefinition abiDefinition : events) {
                ABIObject outputObject = ABIObjectFactory.createEventInputObject(abiDefinition);
                for (TransactionReceipt.Logs log : logs) {
                    String eventSignature = this.eventEncoder.buildEventSignature(this.decodeMethodSign(abiDefinition));
                    if (log.getTopics().isEmpty() || !log.getTopics().contains(eventSignature)) continue;
                    try {
                        List<Object> list = ContractCodecTools.decodeJavaObject(outputObject, log.getData(), this.contractCodec.isWasm());
                        if (result.containsKey(name)) {
                            ((List)result.get(name)).add(list);
                            continue;
                        }
                        ArrayList<List<Object>> l = new ArrayList<List<Object>>();
                        l.add(list);
                        result.put((String)name, (List<List<Object>>)l);
                    }
                    catch (Exception e) {
                        logger.error(" exception in decodeEventToObject: ", (Throwable)e);
                    }
                }
            }
        });
        return result;
    }

    private String decodeMethodSign(ABIDefinition abiDefinition) {
        List<ABIDefinition.NamedType> inputTypes = abiDefinition.getInputs();
        StringBuilder methodSign = new StringBuilder();
        methodSign.append(abiDefinition.getName());
        methodSign.append("(");
        String params = inputTypes.stream().map(ABIDefinition.NamedType::getType).collect(Collectors.joining(","));
        methodSign.append(params);
        methodSign.append(")");
        return methodSign.toString();
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }
}

