/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.codec.encode;

import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.utilities.tx.TransactionBuilderJniObj;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.crypto.signature.Signature;
import org.fisco.bcos.sdk.v3.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.v3.transaction.codec.encode.TransactionEncoderInterface;
import org.fisco.bcos.sdk.v3.transaction.signer.RemoteSignProviderInterface;
import org.fisco.bcos.sdk.v3.transaction.signer.TransactionSignerFactory;
import org.fisco.bcos.sdk.v3.transaction.signer.TransactionSignerInterface;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionEncoderService
implements TransactionEncoderInterface {
    protected static Logger logger = LoggerFactory.getLogger(TransactionEncoderService.class);
    private final Signature signature;
    private final TransactionSignerInterface transactionSignerService;
    private final CryptoSuite cryptoSuite;

    public TransactionEncoderService(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
        this.signature = cryptoSuite.getSignatureImpl();
        this.transactionSignerService = TransactionSignerFactory.createTransactionSigner(this.signature);
    }

    public TransactionEncoderService(CryptoSuite cryptoSuite, RemoteSignProviderInterface transactionSignProvider) {
        this.cryptoSuite = cryptoSuite;
        this.signature = cryptoSuite.getSignatureImpl();
        this.transactionSignerService = TransactionSignerFactory.createTransactionSigner(transactionSignProvider, cryptoSuite.getCryptoTypeConfig());
    }

    @Override
    public byte[] encode(long transactionData) throws JniException {
        String encodedTransactionData = TransactionBuilderJniObj.encodeTransactionData((long)transactionData);
        return Hex.decode(encodedTransactionData);
    }

    @Override
    public String encodeAndSign(long transactionData, CryptoKeyPair cryptoKeyPair, int attribute) throws JniException {
        return Hex.toHexString(this.encodeAndSignBytes(transactionData, cryptoKeyPair, attribute));
    }

    @Override
    public byte[] encodeAndHashBytes(long transactionData) throws JniException {
        byte[] encode = this.encode(transactionData);
        return this.cryptoSuite.hash(encode);
    }

    @Override
    public byte[] encodeAndSignBytes(long transactionData, CryptoKeyPair cryptoKeyPair, int attribute) throws JniException {
        byte[] hash = this.encodeAndHashBytes(transactionData);
        SignatureResult result = this.transactionSignerService.sign(hash, cryptoKeyPair);
        return this.encodeToTransactionBytes(transactionData, hash, result, attribute);
    }

    @Override
    public byte[] encodeToTransactionBytes(long transactionData, byte[] hash, SignatureResult result, int attribute) throws JniException {
        String signedTransaction = TransactionBuilderJniObj.createSignedTransaction((long)transactionData, (String)Hex.toHexString(result.encode()), (String)Hex.toHexString(hash), (int)attribute);
        return Hex.decode(signedTransaction);
    }

    @Override
    public byte[] encodeToTransactionBytes(long transactionData, SignatureResult result, int attribute) throws JniException {
        byte[] hash = this.cryptoSuite.hash(this.encode(transactionData));
        return this.encodeToTransactionBytes(transactionData, hash, result, attribute);
    }

    public Signature getSignature() {
        return this.signature;
    }
}

