/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.manager;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.utilities.tx.TransactionBuilderJniObj;
import org.fisco.bcos.sdk.jni.utilities.tx.TxPair;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.client.RespCallback;
import org.fisco.bcos.sdk.v3.client.protocol.response.Call;
import org.fisco.bcos.sdk.v3.codec.ContractCodec;
import org.fisco.bcos.sdk.v3.codec.ContractCodecException;
import org.fisco.bcos.sdk.v3.codec.abi.Constant;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.v3.codec.wrapper.ABIObject;
import org.fisco.bcos.sdk.v3.codec.wrapper.ContractABIDefinition;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.v3.model.Response;
import org.fisco.bcos.sdk.v3.model.RetCode;
import org.fisco.bcos.sdk.v3.model.TransactionReceipt;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.TransactionDecoderInterface;
import org.fisco.bcos.sdk.v3.transaction.codec.decode.TransactionDecoderService;
import org.fisco.bcos.sdk.v3.transaction.manager.AssembleTransactionProcessorInterface;
import org.fisco.bcos.sdk.v3.transaction.manager.TransactionProcessor;
import org.fisco.bcos.sdk.v3.transaction.model.dto.CallRequest;
import org.fisco.bcos.sdk.v3.transaction.model.dto.CallResponse;
import org.fisco.bcos.sdk.v3.transaction.model.dto.ResultCodeEnum;
import org.fisco.bcos.sdk.v3.transaction.model.dto.TransactionResponse;
import org.fisco.bcos.sdk.v3.transaction.model.exception.NoSuchTransactionFileException;
import org.fisco.bcos.sdk.v3.transaction.model.exception.TransactionBaseException;
import org.fisco.bcos.sdk.v3.transaction.pusher.TransactionPusherInterface;
import org.fisco.bcos.sdk.v3.transaction.pusher.TransactionPusherService;
import org.fisco.bcos.sdk.v3.transaction.tools.ContractLoader;
import org.fisco.bcos.sdk.v3.transaction.tools.JsonUtils;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleTransactionProcessor
extends TransactionProcessor
implements AssembleTransactionProcessorInterface {
    protected static Logger log = LoggerFactory.getLogger(AssembleTransactionProcessor.class);
    protected final TransactionDecoderInterface transactionDecoder;
    protected final TransactionPusherInterface transactionPusher;
    protected final ContractCodec contractCodec;
    protected ContractLoader contractLoader;

    public AssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, String groupId, String chainId, ContractLoader contractLoader) {
        super(client, cryptoKeyPair, groupId, chainId);
        this.transactionDecoder = new TransactionDecoderService(this.cryptoSuite, client.isWASM());
        this.transactionPusher = new TransactionPusherService(client);
        this.contractCodec = new ContractCodec(this.cryptoSuite, client.isWASM());
        this.contractLoader = contractLoader;
    }

    public AssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, String groupId, String chainId, String contractName, String abi, String bin) {
        super(client, cryptoKeyPair, groupId, chainId);
        this.transactionDecoder = new TransactionDecoderService(this.cryptoSuite, client.isWASM());
        this.transactionPusher = new TransactionPusherService(client);
        this.contractCodec = new ContractCodec(this.cryptoSuite, client.isWASM());
        this.contractLoader = new ContractLoader(contractName, abi, bin);
    }

    @Override
    public String deployOnly(String abi, String bin, List<Object> params, String path) throws ContractCodecException {
        return this.deployOnly(abi, bin, params, path, this.cryptoKeyPair);
    }

    @Override
    public String deployOnly(String abi, String bin, List<Object> params) throws ContractCodecException {
        return this.deployOnly(abi, bin, params, "", this.cryptoKeyPair);
    }

    @Override
    public String deployOnly(String abi, String bin, List<Object> params, String path, CryptoKeyPair cryptoKeyPair) throws ContractCodecException {
        TxPair txPair = this.createSignedConstructor(abi, bin, params, path, cryptoKeyPair);
        this.transactionPusher.pushOnly(txPair.getSignedTx());
        return txPair.getTxHash();
    }

    @Override
    public TransactionReceipt deployAndGetReceipt(byte[] data, String abi, String path) {
        return this.deployAndGetReceipt(data, abi, path, this.cryptoKeyPair);
    }

    @Override
    public TransactionReceipt deployAndGetReceipt(byte[] data) {
        return this.deployAndGetReceipt(data, "", "", this.cryptoKeyPair);
    }

    public TransactionReceipt deployAndGetReceipt(byte[] data, String abi, String path, CryptoKeyPair cryptoKeyPair) {
        TxPair txPair;
        TransactionReceipt transactionReceipt;
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 10;
        }
        if (Objects.nonNull(transactionReceipt = this.transactionPusher.push((txPair = this.createDeploySignedTransaction(path, data, abi, cryptoKeyPair, txAttribute)).getSignedTx())) && (Objects.isNull(transactionReceipt.getTransactionHash()) || "".equals(transactionReceipt.getTransactionHash()))) {
            transactionReceipt.setTransactionHash(txPair.getTxHash());
        }
        return transactionReceipt;
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String signedData) {
        TransactionReceipt receipt = this.transactionPusher.push(signedData);
        try {
            return this.transactionDecoder.decodeReceiptWithoutValues(abi, receipt);
        }
        catch (ContractCodecException e) {
            log.error("deploy exception: ", (Throwable)e);
            return new TransactionResponse(receipt, ResultCodeEnum.EXCEPTION_OCCUR.getCode(), e.getMessage());
        }
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String bin, List<Object> params, String path) throws ContractCodecException {
        return this.deployAndGetResponse(abi, bin, params, path, this.cryptoKeyPair);
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String bin, List<Object> params, String path, CryptoKeyPair cryptoKeyPair) throws ContractCodecException {
        TxPair txPair = this.createSignedConstructor(abi, bin, params, path, cryptoKeyPair);
        return this.deployAndGetResponse(abi, txPair.getSignedTx());
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String bin, List<Object> params) throws ContractCodecException {
        return this.deployAndGetResponse(abi, bin, params, "", this.cryptoKeyPair);
    }

    @Override
    public TransactionResponse deployAndGetResponseWithStringParams(String abi, String bin, List<String> params, String path) throws ContractCodecException {
        return this.deployAndGetResponseWithStringParams(abi, bin, params, path, this.cryptoKeyPair);
    }

    @Override
    public TransactionResponse deployAndGetResponseWithStringParams(String abi, String bin, List<String> params, String path, CryptoKeyPair cryptoKeyPair) throws ContractCodecException {
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 10;
        }
        TxPair txPair = this.createDeploySignedTransaction(path, this.contractCodec.encodeConstructorFromString(abi, bin, params), abi, cryptoKeyPair, txAttribute);
        return this.deployAndGetResponse(abi, txPair.getSignedTx());
    }

    @Override
    public String deployAsync(String abi, String bin, List<Object> params, TransactionCallback callback) throws ContractCodecException {
        return this.deployAsync(abi, bin, params, "", this.cryptoKeyPair, callback);
    }

    @Override
    public String deployAsync(String abi, String bin, List<Object> params, String path, TransactionCallback callback) throws ContractCodecException {
        return this.deployAsync(abi, bin, params, path, this.cryptoKeyPair, callback);
    }

    @Override
    public String deployAsync(String abi, String bin, List<Object> params, String path, CryptoKeyPair cryptoKeyPair, TransactionCallback callback) throws ContractCodecException {
        TxPair txPair = this.createSignedConstructor(abi, bin, params, path, cryptoKeyPair);
        this.transactionPusher.pushAsync(txPair.getSignedTx(), callback);
        return txPair.getTxHash();
    }

    @Override
    public CompletableFuture<TransactionReceipt> deployAsync(String abi, String bin, List<Object> params, String path) throws ContractCodecException {
        return this.deployAsync(abi, bin, params, path, this.cryptoKeyPair);
    }

    @Override
    public CompletableFuture<TransactionReceipt> deployAsync(String abi, String bin, List<Object> params) throws ContractCodecException, JniException {
        return this.deployAsync(abi, bin, params, "", this.cryptoKeyPair);
    }

    @Override
    public CompletableFuture<TransactionReceipt> deployAsync(String abi, String bin, List<Object> params, String path, CryptoKeyPair cryptoKeyPair) throws ContractCodecException {
        TxPair txPair = this.createSignedConstructor(abi, bin, params, path, cryptoKeyPair);
        return this.transactionPusher.pushAsync(txPair.getSignedTx());
    }

    @Override
    public TransactionResponse deployByContractLoader(String contractName, List<Object> args) throws ContractCodecException, TransactionBaseException {
        return this.deployAndGetResponse(this.contractLoader.getABIByContractName(contractName), this.contractLoader.getBinaryByContractName(contractName), args);
    }

    @Override
    public void deployByContractLoaderAsync(String contractName, List<Object> args, TransactionCallback callback) throws ContractCodecException, NoSuchTransactionFileException {
        this.deployAsync(this.contractLoader.getABIByContractName(contractName), this.contractLoader.getBinaryByContractName(contractName), args, callback);
    }

    @Override
    public void sendTransactionOnly(String signedData) {
        this.transactionPusher.pushOnly(signedData);
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponse(String to, String abi, String functionName, byte[] data) {
        return this.sendTransactionAndGetResponse(to, abi, functionName, data, this.cryptoKeyPair);
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponse(String to, String abi, String functionName, byte[] data, CryptoKeyPair cryptoKeyPair) {
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 2;
        }
        TxPair txPair = this.createSignedTransaction(to, data, cryptoKeyPair, txAttribute);
        TransactionReceipt receipt = this.transactionPusher.push(txPair.getSignedTx());
        try {
            return this.transactionDecoder.decodeReceiptWithValues(abi, functionName, receipt);
        }
        catch (ContractCodecException e) {
            log.error("sendTransaction exception: ", (Throwable)e);
            return new TransactionResponse(receipt, ResultCodeEnum.EXCEPTION_OCCUR.getCode(), e.getMessage());
        }
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponse(String to, String abi, String functionName, List<Object> params) throws ContractCodecException {
        byte[] data = this.encodeFunction(abi, functionName, params);
        return this.sendTransactionAndGetResponse(to, abi, functionName, data);
    }

    @Override
    public TransactionResponse sendTransactionWithStringParamsAndGetResponse(String to, String abi, String functionName, List<String> params) throws ContractCodecException {
        byte[] data = this.contractCodec.encodeMethodFromString(abi, functionName, params);
        return this.sendTransactionAndGetResponse(to, abi, functionName, data);
    }

    @Override
    public TransactionReceipt sendTransactionAndGetReceiptByContractLoader(String contractName, String contractAddress, String functionName, List<Object> args) throws ContractCodecException, TransactionBaseException {
        byte[] data = this.contractCodec.encodeMethod(this.contractLoader.getABIByContractName(contractName), functionName, args);
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 2;
        }
        return this.sendTransactionAndGetReceipt(contractAddress, data, this.cryptoKeyPair, txAttribute);
    }

    @Override
    public TransactionResponse sendTransactionAndGetResponseByContractLoader(String contractName, String contractAddress, String functionName, List<Object> funcParams) throws ContractCodecException, TransactionBaseException {
        return this.sendTransactionAndGetResponse(contractAddress, this.contractLoader.getABIByContractName(contractName), functionName, funcParams);
    }

    @Override
    public void sendTransactionAsync(String signedTransaction, TransactionCallback callback) {
        this.transactionPusher.pushAsync(signedTransaction, callback);
    }

    @Override
    public void sendTransactionAsync(String to, String abi, String functionName, List<Object> params, TransactionCallback callback) throws ContractCodecException {
        byte[] data = this.encodeFunction(abi, functionName, params);
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 2;
        }
        this.sendTransactionAsync(to, data, this.cryptoKeyPair, txAttribute, callback);
    }

    @Override
    public CompletableFuture<TransactionReceipt> sendTransactionAsync(String signedData) {
        return this.transactionPusher.pushAsync(signedData);
    }

    @Override
    public void sendTransactionAndGetReceiptByContractLoaderAsync(String contractName, String contractAddress, String functionName, List<Object> args, TransactionCallback callback) throws ContractCodecException, TransactionBaseException {
        String abi = this.contractLoader.getABIByContractName(contractName);
        byte[] data = this.contractCodec.encodeMethod(abi, functionName, args);
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 2;
        }
        this.sendTransactionAsync(contractAddress, data, this.cryptoKeyPair, txAttribute, callback);
    }

    @Override
    public CallResponse sendCallByContractLoader(String contractName, String contractAddress, String functionName, List<Object> args) throws TransactionBaseException, ContractCodecException {
        return this.sendCall(this.cryptoKeyPair.getAddress(), contractAddress, this.contractLoader.getABIByContractName(contractName), functionName, args);
    }

    @Override
    public CallResponse sendCall(String from, String to, String abi, String functionName, List<Object> paramsList) throws TransactionBaseException, ContractCodecException {
        List<ABIDefinition> abiDefinitions = this.getAbiDefinition(abi, functionName, paramsList.size());
        if (abiDefinitions == null || abiDefinitions.isEmpty()) {
            throw new ContractCodecException(Constant.NO_APPROPRIATE_ABI_METHOD);
        }
        byte[] data = null;
        ABIDefinition abiDefinition = null;
        for (ABIDefinition definition : abiDefinitions) {
            try {
                abiDefinition = definition;
                data = this.contractCodec.encodeMethodByAbiDefinition(definition, paramsList);
            }
            catch (ContractCodecException e) {
                if (abiDefinitions.size() != 1) continue;
                throw e;
            }
        }
        if (data == null) {
            throw new ContractCodecException("cannot encode in encodeMethodByAbiDefinition with appropriate interface ABI");
        }
        return this.callAndGetResponse(from, to, abiDefinition, data);
    }

    private List<ABIDefinition> getAbiDefinition(String abi, String functionName, int paramsSize) throws ContractCodecException {
        ContractABIDefinition contractABIDefinition = this.contractCodec.getAbiDefinitionFactory().loadABI(abi);
        List<ABIDefinition> methods = contractABIDefinition.getFunctions().get(functionName);
        if (methods == null || methods.isEmpty()) {
            throw new ContractCodecException(Constant.NO_APPROPRIATE_ABI_METHOD);
        }
        return methods.stream().filter(d -> d.getInputs().size() == paramsSize).collect(Collectors.toList());
    }

    @Override
    public CallResponse sendCall(CallRequest callRequest) throws TransactionBaseException, ContractCodecException {
        Call call = this.executeCall(callRequest);
        CallResponse callResponse = this.parseCallResponseStatus(call.getCallResult());
        String callOutput = call.getCallResult().getOutput();
        Pair<List<Object>, List<ABIObject>> results = this.contractCodec.decodeMethodAndGetOutputObject(callRequest.getAbi(), callOutput);
        callResponse.setValues(JsonUtils.toJson(results.getLeft()));
        callResponse.setReturnObject((List)results.getLeft());
        callResponse.setReturnABIObject((List)results.getRight());
        return callResponse;
    }

    @Override
    public void sendCallAsync(String from, String to, String abi, String functionName, List<Object> params, RespCallback<CallResponse> callback) throws ContractCodecException {
        List<ABIDefinition> abiDefinitions = this.getAbiDefinition(abi, functionName, params.size());
        if (abiDefinitions == null || abiDefinitions.isEmpty()) {
            throw new ContractCodecException(Constant.NO_APPROPRIATE_ABI_METHOD);
        }
        byte[] data = null;
        ABIDefinition abiDefinition = null;
        for (ABIDefinition definition : abiDefinitions) {
            try {
                abiDefinition = definition;
                data = this.contractCodec.encodeMethodByAbiDefinition(abiDefinition, params);
            }
            catch (ContractCodecException e) {
                if (abiDefinitions.size() != 1) continue;
                throw e;
            }
        }
        if (data == null) {
            throw new ContractCodecException("cannot encode in encodeMethodByAbiDefinition with appropriate interface ABI");
        }
        this.callAndGetResponseAsync(from, to, abiDefinition, data, callback);
    }

    @Override
    public void sendCallAsync(final CallRequest callRequest, final RespCallback<CallResponse> callback) {
        this.asyncExecuteCall(callRequest, new RespCallback<Call>(){

            @Override
            public void onResponse(Call call) {
                try {
                    CallResponse callResponse = AssembleTransactionProcessor.this.parseCallResponseStatus(call.getCallResult());
                    String callOutput = call.getCallResult().getOutput();
                    Pair<List<Object>, List<ABIObject>> results = AssembleTransactionProcessor.this.contractCodec.decodeMethodAndGetOutputObject(callRequest.getAbi(), callOutput);
                    callResponse.setValues(JsonUtils.toJson(results.getLeft()));
                    callResponse.setReturnObject((List)results.getLeft());
                    callResponse.setReturnABIObject((List)results.getRight());
                    callback.onResponse(callResponse);
                }
                catch (ContractCodecException | TransactionBaseException e) {
                    Response response = new Response();
                    response.setErrorMessage(e.getMessage());
                    response.setErrorCode(-5000);
                    callback.onError(response);
                }
            }

            @Override
            public void onError(Response errorResponse) {
                callback.onError(errorResponse);
            }
        });
    }

    @Override
    public CallResponse sendCallWithStringParams(String from, String to, String abi, String functionName, List<String> paramsList) throws TransactionBaseException, ContractCodecException {
        List<ABIDefinition> abiDefinitions = this.getAbiDefinition(abi, functionName, paramsList.size());
        if (log.isTraceEnabled()) {
            log.trace("sendCallWithStringParams, to:{}, functionName:{}, params:{}", new Object[]{to, functionName, paramsList});
        }
        if (abiDefinitions == null || abiDefinitions.isEmpty()) {
            throw new ContractCodecException(Constant.NO_APPROPRIATE_ABI_METHOD);
        }
        byte[] data = null;
        ABIDefinition abiDefinition = null;
        for (ABIDefinition definition : abiDefinitions) {
            try {
                abiDefinition = definition;
                data = this.contractCodec.encodeMethodByIdFromString(abi, abiDefinition.getMethodId(this.cryptoSuite), paramsList);
            }
            catch (ContractCodecException e) {
                if (abiDefinitions.size() != 1) continue;
                throw e;
            }
        }
        if (data == null) {
            throw new ContractCodecException("cannot encode in encodeMethodByIdFromString with appropriate interface ABI");
        }
        return this.callAndGetResponse(from, to, abiDefinition, data);
    }

    @Override
    public void sendCallWithStringParamsAsync(String from, String to, String abi, String functionName, List<String> params, RespCallback<CallResponse> callback) throws TransactionBaseException, ContractCodecException {
        List<ABIDefinition> abiDefinitions = this.getAbiDefinition(abi, functionName, params.size());
        if (abiDefinitions == null || abiDefinitions.isEmpty()) {
            throw new ContractCodecException(Constant.NO_APPROPRIATE_ABI_METHOD);
        }
        byte[] data = null;
        ABIDefinition abiDefinition = null;
        for (ABIDefinition definition : abiDefinitions) {
            try {
                abiDefinition = definition;
                data = this.contractCodec.encodeMethodByIdFromString(abi, abiDefinition.getMethodId(this.cryptoSuite), params);
            }
            catch (ContractCodecException e) {
                if (abiDefinitions.size() != 1) continue;
                throw e;
            }
        }
        if (data == null) {
            throw new ContractCodecException("cannot encode in encodeMethodByIdFromString with appropriate interface ABI");
        }
        this.callAndGetResponseAsync(from, to, abiDefinition, data, callback);
    }

    private void callAndGetResponseAsync(String from, String to, final ABIDefinition abiDefinition, byte[] data, final RespCallback<CallResponse> callback) {
        this.asyncExecuteCall(from, to, data, new RespCallback<Call>(){

            @Override
            public void onResponse(Call call) {
                try {
                    CallResponse callResponse = AssembleTransactionProcessor.this.parseCallResponseStatus(call.getCallResult());
                    List<Type> decodedResult = AssembleTransactionProcessor.this.contractCodec.decodeMethodByABIDefinition(abiDefinition, call.getCallResult().getOutput());
                    callResponse.setResults(decodedResult);
                    callback.onResponse(callResponse);
                }
                catch (ContractCodecException | TransactionBaseException e) {
                    Response response = new Response();
                    response.setErrorMessage(e.getMessage());
                    response.setErrorCode(-5000);
                    callback.onError(response);
                }
            }

            @Override
            public void onError(Response errorResponse) {
                callback.onError(errorResponse);
            }
        });
    }

    public CallResponse callAndGetResponse(String from, String to, String abi, String functionName, byte[] data) throws ContractCodecException, TransactionBaseException {
        Call call = this.executeCall(from, to, data);
        CallResponse callResponse = this.parseCallResponseStatus(call.getCallResult());
        List<Type> decodedResult = this.contractCodec.decodeMethodAndGetOutputObject(abi, functionName, call.getCallResult().getOutput());
        callResponse.setResults(decodedResult);
        return callResponse;
    }

    public CallResponse callAndGetResponse(String from, String to, ABIDefinition abiDefinition, byte[] data) throws ContractCodecException, TransactionBaseException {
        Call call = this.executeCall(from, to, data);
        CallResponse callResponse = this.parseCallResponseStatus(call.getCallResult());
        List<Type> decodedResult = this.contractCodec.decodeMethodByABIDefinition(abiDefinition, call.getCallResult().getOutput());
        callResponse.setResults(decodedResult);
        return callResponse;
    }

    @Override
    public TxPair createSignedConstructor(String abi, String bin, List<Object> params, String path) throws ContractCodecException {
        return this.createSignedConstructor(abi, bin, params, path, this.cryptoKeyPair);
    }

    @Override
    public TxPair createSignedConstructor(String abi, String bin, List<Object> params, String path, CryptoKeyPair cryptoKeyPair) throws ContractCodecException {
        int txAttribute = 0;
        if (this.client.isWASM().booleanValue()) {
            txAttribute = 10;
        }
        return this.createDeploySignedTransaction(Objects.nonNull(path) ? path : "", this.contractCodec.encodeConstructor(abi, bin, params), abi, cryptoKeyPair == null ? this.cryptoKeyPair : cryptoKeyPair, txAttribute);
    }

    @Override
    public byte[] encodeFunction(String abi, String functionName, List<Object> params) throws ContractCodecException {
        return this.contractCodec.encodeMethod(abi, functionName, params);
    }

    @Override
    public long getRawTransactionForConstructor(String abi, String bin, List<Object> params) throws ContractCodecException, JniException {
        return TransactionBuilderJniObj.createTransactionData((String)this.groupId, (String)this.chainId, (String)"", (String)Hex.toHexString(this.contractCodec.encodeConstructor(abi, bin, params)), (String)abi, (long)this.client.getBlockLimit().longValue());
    }

    @Override
    public long getRawTransactionForConstructor(BigInteger blockLimit, String abi, String bin, List<Object> params) throws ContractCodecException, JniException {
        return TransactionBuilderJniObj.createTransactionData((String)this.groupId, (String)this.chainId, (String)"", (String)Hex.toHexString(this.contractCodec.encodeConstructor(abi, bin, params)), (String)abi, (long)blockLimit.longValue());
    }

    @Override
    public long getRawTransaction(String to, String abi, String functionName, List<Object> params) throws ContractCodecException, JniException {
        return TransactionBuilderJniObj.createTransactionData((String)this.groupId, (String)this.chainId, (String)to, (String)Hex.toHexString(this.contractCodec.encodeMethod(abi, functionName, params)), (String)"", (long)this.client.getBlockLimit().longValue());
    }

    @Override
    public long getRawTransaction(BigInteger blockLimit, String to, String abi, String functionName, List<Object> params) throws ContractCodecException, JniException {
        return TransactionBuilderJniObj.createTransactionData((String)this.groupId, (String)this.chainId, (String)to, (String)Hex.toHexString(this.contractCodec.encodeMethod(abi, functionName, params)), (String)"", (long)blockLimit.longValue());
    }

    private CallResponse parseCallResponseStatus(Call.CallOutput callOutput) throws TransactionBaseException {
        CallResponse callResponse = new CallResponse();
        RetCode retCode = ReceiptParser.parseCallOutput(callOutput, "");
        callResponse.setReturnCode(callOutput.getStatus());
        callResponse.setReturnMessage(retCode.getMessage());
        if (!retCode.getMessage().equals(PrecompiledRetCode.CODE_SUCCESS.getMessage())) {
            throw new TransactionBaseException(retCode);
        }
        return callResponse;
    }

    public ContractLoader getContractLoader() {
        return this.contractLoader;
    }
}

