/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.transaction.manager;

import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.v3.transaction.manager.AssembleTransactionProcessor;
import org.fisco.bcos.sdk.v3.transaction.manager.AssembleTransactionWithRemoteSignProcessor;
import org.fisco.bcos.sdk.v3.transaction.manager.TransactionProcessor;
import org.fisco.bcos.sdk.v3.transaction.signer.RemoteSignProviderInterface;
import org.fisco.bcos.sdk.v3.transaction.tools.ContractLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(TransactionProcessorFactory.class);

    private TransactionProcessorFactory() {
    }

    public static Pair<String, String> getChainIdAndGroupId(Client client) {
        String chainId = client.getChainId();
        String group = client.getGroup();
        logger.debug("createTransactionManager, chainId: {}, groupId: {}", (Object)chainId, (Object)group);
        return Pair.of((Object)chainId, (Object)group);
    }

    public static TransactionProcessor createTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair) {
        Pair<String, String> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new TransactionProcessor(client, cryptoKeyPair, (String)pair.getRight(), (String)pair.getLeft());
    }

    public static AssembleTransactionProcessor createAssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair) {
        Pair<String, String> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new AssembleTransactionProcessor(client, cryptoKeyPair, (String)pair.getRight(), (String)pair.getLeft(), null);
    }

    public static AssembleTransactionProcessor createAssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, String abiFilePath, String binFilePath) throws IOException {
        Pair<String, String> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        ContractLoader contractLoader = new ContractLoader(abiFilePath, binFilePath);
        return new AssembleTransactionProcessor(client, cryptoKeyPair, (String)pair.getRight(), (String)pair.getLeft(), contractLoader);
    }

    public static AssembleTransactionProcessor createAssembleTransactionProcessor(Client client, CryptoKeyPair cryptoKeyPair, String contractName, String abi, String bin) {
        Pair<String, String> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new AssembleTransactionProcessor(client, cryptoKeyPair, (String)pair.getRight(), (String)pair.getLeft(), contractName, abi, bin);
    }

    public static AssembleTransactionWithRemoteSignProcessor createAssembleTransactionWithRemoteSignProcessor(Client client, CryptoKeyPair cryptoKeyPair, String contractName, RemoteSignProviderInterface transactionSignProvider) {
        Pair<String, String> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        return new AssembleTransactionWithRemoteSignProcessor(client, cryptoKeyPair, (String)pair.getRight(), (String)pair.getLeft(), contractName, transactionSignProvider);
    }

    public static AssembleTransactionWithRemoteSignProcessor createAssembleTransactionWithRemoteSignProcessor(Client client, CryptoKeyPair cryptoKeyPair, String abiFilePath, String binFilePath, RemoteSignProviderInterface transactionSignProvider) throws IOException {
        Pair<String, String> pair = TransactionProcessorFactory.getChainIdAndGroupId(client);
        ContractLoader contractLoader = new ContractLoader(abiFilePath, binFilePath);
        return new AssembleTransactionWithRemoteSignProcessor(client, cryptoKeyPair, (String)pair.getRight(), (String)pair.getLeft(), contractLoader, transactionSignProvider);
    }
}

