/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.utils;

import java.util.Objects;
import org.fisco.bcos.sdk.v3.utils.Hex;
import org.fisco.bcos.sdk.v3.utils.Numeric;

public class AddressUtils {
    public static final String ADDRESS_PATTERN = "^[0-9A-Fa-f]{1,40}$";
    public static final String FULL_ADDRESS_PATTERN = "^[0-9A-Fa-f]{40}$";

    private AddressUtils() {
    }

    public static boolean isValidAddress(String address) {
        String addressNoPrefix = Numeric.cleanHexPrefix(address);
        return addressNoPrefix.matches(ADDRESS_PATTERN);
    }

    public static boolean isValidFullAddress(String address) {
        String addressNoPrefix = Numeric.cleanHexPrefix(address);
        return addressNoPrefix.matches(FULL_ADDRESS_PATTERN);
    }

    public static String addHexPrefixToAddress(String address) {
        if (!Objects.isNull(address) && !address.startsWith("0x") && !address.startsWith("0X") && AddressUtils.isValidFullAddress(address)) {
            return Hex.addPrefix(address);
        }
        return address;
    }
}

