/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.utils;

import java.nio.ByteBuffer;
import java.util.List;
import org.fisco.bcos.sdk.v3.crypto.hash.Hash;
import org.fisco.bcos.sdk.v3.utils.Hex;

public class MerkleCalculator {
    private MerkleCalculator() {
    }

    public static String calculateMerkleRoot(List<String> merkleProof, String hash, Hash hashImpl) throws Exception {
        int count;
        if (merkleProof == null || merkleProof.size() == 1) {
            return hash;
        }
        String result = hash;
        for (int beginFlag = 0; beginFlag < merkleProof.size(); beginFlag += count) {
            String nextLevelCount;
            List<String> nextLevelProof;
            if (!(nextLevelProof = merkleProof.subList(++beginFlag, beginFlag + (count = MerkleCalculator.hashToNumber(nextLevelCount = merkleProof.get(beginFlag))))).contains(result)) {
                throw new Exception("CalculateMerkleRoot failed, proof or hash mismatch.");
            }
            String collect = String.join((CharSequence)"", nextLevelProof);
            byte[] hashResult = hashImpl.hash(Hex.decode(collect));
            result = Hex.toHexString(hashResult);
        }
        return result;
    }

    private static int hashToNumber(String nextLevelCount) {
        byte[] decode = Hex.decode(nextLevelCount);
        ByteBuffer byteBuffer = ByteBuffer.wrap(decode);
        return byteBuffer.getInt();
    }
}

