/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.examples;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PercentileTracker {
    private long windowMillis;
    protected ConcurrentSkipListMap<Long, Double> cslm = new ConcurrentSkipListMap();

    public PercentileTracker(long windowMillis) {
        this.windowMillis = windowMillis;
    }

    public synchronized void update(double sample) {
        long now = System.currentTimeMillis();
        this.removeOutOfTimeWindowEntries();
        this.cslm.put(now, sample);
    }

    public double getPercentile(int requestedPercentile) {
        return this.getPercentile(requestedPercentile, new ArrayList(this.cslm.values()));
    }

    protected double getPercentile(int requestedPercentile, ArrayList<Double> values) {
        double returnPercentile;
        if (values == null || values.size() == 0) {
            return 0.0;
        }
        Collections.sort(values);
        Double[] mySampleSet = values.toArray(new Double[values.size()]);
        double rank = (double)requestedPercentile / 100.0 * (double)(values.size() - 1) + 1.0;
        int integerRank = (int)rank;
        double remainder = rank - (double)integerRank;
        if (remainder > 0.0) {
            double valueAtRankIr = mySampleSet[integerRank - 1];
            double valueAtRankIrPlusOne = mySampleSet[integerRank];
            returnPercentile = remainder * (valueAtRankIrPlusOne - valueAtRankIr) + valueAtRankIr;
        } else {
            returnPercentile = mySampleSet[integerRank - 1];
        }
        return returnPercentile;
    }

    private void removeOutOfTimeWindowEntries() {
        if (this.cslm.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - (Long)this.cslm.lastKey() > this.windowMillis) {
            this.cslm.clear();
            return;
        }
        while ((Long)this.cslm.lastKey() - (Long)this.cslm.firstKey() > this.windowMillis) {
            this.cslm.pollFirstEntry();
        }
    }
}

