/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.examples.webapp;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fishwife.jrugged.examples.InterceptResponseTweaker;
import org.fishwife.jrugged.spring.PerformanceMonitorBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InterceptPerformanceMonitorExample {
    @Autowired
    private PerformanceMonitorBean performanceBean;
    @Autowired
    private InterceptResponseTweaker interceptResponseTweaker;

    public PerformanceMonitorBean getPerformanceBean() {
        return this.performanceBean;
    }

    public void setPerformanceBean(PerformanceMonitorBean performanceBean) {
        this.performanceBean = performanceBean;
    }

    public InterceptResponseTweaker getResponseTweaker() {
        return this.interceptResponseTweaker;
    }

    public void setResponseTweaker(InterceptResponseTweaker interceptResponseTweaker) {
        this.interceptResponseTweaker = interceptResponseTweaker;
    }

    @RequestMapping(value={"/interceptPerformanceMonitor"})
    public ModelAndView viewMain(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delayedFor = this.interceptResponseTweaker.delay();
        ModelAndView view = new ModelAndView("interceptPerf-monitor");
        view.addObject("delay", (Object)new Integer(delayedFor));
        return view;
    }

    @RequestMapping(value={"/interceptPerformanceMonitor/stats"})
    public ModelAndView viewPerformanceMonitor(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Method[] methods;
        StringBuilder sb = new StringBuilder();
        for (Method monitorMethod : methods = this.performanceBean.getClass().getMethods()) {
            if (!monitorMethod.getName().startsWith("get")) continue;
            sb.append(String.format("\t%s: %s\n", monitorMethod.getName().substring(3), monitorMethod.invoke((Object)this.performanceBean, new Object[0])));
        }
        sb.append("\n");
        response.setContentType("text/plain");
        response.getWriter().println(sb.toString());
        return null;
    }
}

