/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.exceptions.XMLException;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.MapExceptionEntry;

public class FlowableMapExceptionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "mapException";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Activity)) {
            return;
        }
        String errorCode = xtr.getAttributeValue(null, "errorCode");
        String andChildren = xtr.getAttributeValue(null, "includeChildExceptions");
        String exceptionClass = xtr.getElementText();
        boolean hasChildrenBool = false;
        if (StringUtils.isEmpty((CharSequence)andChildren) || andChildren.toLowerCase().equals("false")) {
            hasChildrenBool = false;
        } else if (andChildren.toLowerCase().equals("true")) {
            hasChildrenBool = true;
        } else {
            throw new XMLException("'" + andChildren + "' is not valid boolean in mapException with errorCode=" + errorCode + " and class=" + exceptionClass);
        }
        if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)errorCode.trim())) {
            throw new XMLException("No errorCode defined mapException with errorCode=" + errorCode + " and class=" + exceptionClass);
        }
        ((Activity)parentElement).getMapExceptions().add(new MapExceptionEntry(errorCode, exceptionClass, hasChildrenBool));
    }
}

