/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.content;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class ContentRestUrlBuilder {
    protected String baseUrl = "";

    protected ContentRestUrlBuilder() {
    }

    protected ContentRestUrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String buildUrl(String[] fragments, Object ... arguments) {
        return this.baseUrl + "/" + MessageFormat.format(StringUtils.join((Object[])fragments, (char)'/'), arguments);
    }

    public static ContentRestUrlBuilder usingBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new FlowableIllegalArgumentException("baseUrl can not be null");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return new ContentRestUrlBuilder(baseUrl);
    }

    public static ContentRestUrlBuilder fromRequest(HttpServletRequest request) {
        return ContentRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).build().toUriString());
    }

    public static ContentRestUrlBuilder fromCurrentRequest() {
        return ContentRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString());
    }
}

