/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.content.service.api.content;

import java.util.HashMap;
import java.util.Map;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentItemQuery;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.impl.ContentItemQueryProperty;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.query.Query;
import org.flowable.engine.common.api.query.QueryProperty;
import org.flowable.rest.api.DataResponse;
import org.flowable.rest.content.ContentRestResponseFactory;
import org.flowable.rest.content.service.api.content.ContentItemPaginateList;
import org.flowable.rest.content.service.api.content.ContentItemQueryRequest;
import org.flowable.rest.content.service.api.content.ContentItemResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentItemBaseResource {
    private static HashMap<String, QueryProperty> properties = new HashMap();
    @Autowired
    protected ContentRestResponseFactory restResponseFactory;
    @Autowired
    protected ContentService contentService;

    protected DataResponse<ContentItemResponse> getContentItemsFromQueryRequest(ContentItemQueryRequest request, Map<String, String> requestParams) {
        ContentItemQuery contentItemQuery = this.contentService.createContentItemQuery();
        if (request.getId() != null) {
            contentItemQuery.id(request.getId());
        }
        if (request.getIds() != null) {
            contentItemQuery.ids(request.getIds());
        }
        if (request.getName() != null) {
            contentItemQuery.name(request.getName());
        }
        if (request.getNameLike() != null) {
            contentItemQuery.nameLike(request.getNameLike());
        }
        if (request.getMimeType() != null) {
            contentItemQuery.mimeType(request.getMimeType());
        }
        if (request.getMimeTypeLike() != null) {
            contentItemQuery.mimeTypeLike(request.getMimeTypeLike());
        }
        if (request.getTaskId() != null) {
            contentItemQuery.taskId(request.getTaskId());
        }
        if (request.getTaskIdLike() != null) {
            contentItemQuery.taskIdLike(request.getTaskIdLike());
        }
        if (request.getProcessInstanceId() != null) {
            contentItemQuery.processInstanceId(request.getProcessInstanceId());
        }
        if (request.getProcessInstanceIdLike() != null) {
            contentItemQuery.processInstanceIdLike(request.getProcessInstanceIdLike());
        }
        if (request.getContentStoreId() != null) {
            contentItemQuery.contentStoreId(request.getContentStoreId());
        }
        if (request.getContentStoreIdLike() != null) {
            contentItemQuery.contentStoreIdLike(request.getContentStoreIdLike());
        }
        if (request.getContentStoreName() != null) {
            contentItemQuery.contentStoreName(request.getContentStoreName());
        }
        if (request.getContentStoreNameLike() != null) {
            contentItemQuery.contentStoreNameLike(request.getContentStoreNameLike());
        }
        if (request.getContentSize() != null) {
            contentItemQuery.contentSize(request.getContentSize());
        }
        if (request.getMinimumContentSize() != null) {
            contentItemQuery.minContentSize(request.getMinimumContentSize());
        }
        if (request.getMaximumContentSize() != null) {
            contentItemQuery.maxContentSize(request.getMaximumContentSize());
        }
        if (request.getContentAvailable() != null) {
            contentItemQuery.contentAvailable(request.getContentAvailable());
        }
        if (request.getField() != null) {
            contentItemQuery.field(request.getField());
        }
        if (request.getFieldLike() != null) {
            contentItemQuery.fieldLike(request.getFieldLike());
        }
        if (request.getCreatedOn() != null) {
            contentItemQuery.createdDate(request.getCreatedOn());
        }
        if (request.getCreatedBefore() != null) {
            contentItemQuery.createdDateBefore(request.getCreatedBefore());
        }
        if (request.getCreatedAfter() != null) {
            contentItemQuery.createdDateAfter(request.getCreatedAfter());
        }
        if (request.getCreatedBy() != null) {
            contentItemQuery.createdBy(request.getCreatedBy());
        }
        if (request.getCreatedByLike() != null) {
            contentItemQuery.createdByLike(request.getCreatedByLike());
        }
        if (request.getLastModifiedOn() != null) {
            contentItemQuery.lastModifiedDate(request.getLastModifiedOn());
        }
        if (request.getLastModifiedBefore() != null) {
            contentItemQuery.lastModifiedDateBefore(request.getLastModifiedBefore());
        }
        if (request.getLastModifiedAfter() != null) {
            contentItemQuery.lastModifiedDateAfter(request.getLastModifiedAfter());
        }
        if (request.getLastModifiedBy() != null) {
            contentItemQuery.lastModifiedBy(request.getLastModifiedBy());
        }
        if (request.getLastModifiedByLike() != null) {
            contentItemQuery.lastModifiedByLike(request.getLastModifiedByLike());
        }
        if (request.getTenantId() != null) {
            contentItemQuery.tenantId(request.getTenantId());
        }
        if (request.getTenantIdLike() != null) {
            contentItemQuery.tenantIdLike(request.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(request.getWithoutTenantId())) {
            contentItemQuery.withoutTenantId();
        }
        return new ContentItemPaginateList(this.restResponseFactory).paginateList(requestParams, request, (Query)contentItemQuery, "created", properties);
    }

    protected ContentItem getContentItemFromRequest(String contentItemId) {
        ContentItem contentItem = (ContentItem)this.contentService.createContentItemQuery().id(contentItemId).singleResult();
        if (contentItem == null) {
            throw new FlowableObjectNotFoundException("Could not find a content item with id '" + contentItemId + "'.", ContentItem.class);
        }
        return contentItem;
    }

    static {
        properties.put("created", (QueryProperty)ContentItemQueryProperty.CREATED_DATE);
        properties.put("tenantId", (QueryProperty)ContentItemQueryProperty.TENANT_ID);
    }
}

