/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.dmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnJsonConverterUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnJsonConverterUtil.class);

    public static String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode jsonNode = objectNode.get(name);
        if (jsonNode != null && !jsonNode.isNull()) {
            propertyValue = jsonNode.asText();
        }
        return propertyValue;
    }

    public static JsonNode migrateModel(JsonNode decisionTableNode, ObjectMapper objectMapper) {
        if (decisionTableNode.get("modelVersion") == null || decisionTableNode.get("modelVersion").isNull()) {
            JsonNode inputExpressionNodes = decisionTableNode.get("inputExpressions");
            HashMap<Object, String> inputExpressionIds = new HashMap<Object, String>();
            if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                for (JsonNode inputExpressionNode : inputExpressionNodes) {
                    if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                    String inputId = inputExpressionNode.get("id").asText();
                    String inputType = null;
                    if (inputExpressionNode.get("type") != null && !inputExpressionNode.get("type").isNull()) {
                        inputType = inputExpressionNode.get("type").asText();
                    }
                    inputExpressionIds.put(inputId, inputType);
                }
            }
            JsonNode ruleNodes = decisionTableNode.get("rules");
            ArrayNode newRuleNodes = objectMapper.createArrayNode();
            if (ruleNodes != null && !ruleNodes.isNull()) {
                for (JsonNode ruleNode : ruleNodes) {
                    ObjectNode newRuleNode = objectMapper.createObjectNode();
                    for (String inputExpressionId : inputExpressionIds.keySet()) {
                        String oldExpression;
                        if (!ruleNode.has(inputExpressionId)) continue;
                        String operatorId = inputExpressionId + "_operator";
                        String expressionId = inputExpressionId + "_expression";
                        String operatorValue = null;
                        String expressionValue = null;
                        if (ruleNode.get(inputExpressionId) != null && !ruleNode.get(inputExpressionId).isNull() && StringUtils.isNotEmpty((CharSequence)(oldExpression = ruleNode.get(inputExpressionId).asText()))) {
                            if (oldExpression.indexOf(32) != -1) {
                                operatorValue = oldExpression.substring(0, oldExpression.indexOf(32));
                                expressionValue = oldExpression.substring(oldExpression.indexOf(32) + 1);
                            } else {
                                expressionValue = oldExpression;
                            }
                            if (expressionValue.startsWith("\"") && expressionValue.endsWith("\"")) {
                                expressionValue = expressionValue.substring(1, expressionValue.length() - 1);
                            }
                            if (expressionValue.startsWith("fn_date(")) {
                                expressionValue = expressionValue.substring(9, expressionValue.lastIndexOf(39));
                            } else if (expressionValue.startsWith("date:toDate(")) {
                                expressionValue = expressionValue.substring(13, expressionValue.lastIndexOf(39));
                            }
                            if (StringUtils.isEmpty((CharSequence)((CharSequence)inputExpressionIds.get(inputExpressionId)))) {
                                String expressionType = DmnJsonConverterUtil.determineExpressionType(expressionValue);
                                inputExpressionIds.put(inputExpressionId, expressionType);
                            }
                        }
                        if (StringUtils.isNotEmpty(operatorValue)) {
                            newRuleNode.put(operatorId, operatorValue);
                        } else {
                            newRuleNode.put(operatorId, "==");
                        }
                        if (StringUtils.isNotEmpty(expressionValue)) {
                            newRuleNode.put(expressionId, expressionValue);
                            continue;
                        }
                        newRuleNode.put(expressionId, "-");
                    }
                    Iterator ruleProperty = ruleNode.fieldNames();
                    while (ruleProperty.hasNext()) {
                        String outputExpressionId = (String)ruleProperty.next();
                        if (inputExpressionIds.containsKey(outputExpressionId)) continue;
                        String outputExpressionValue = ruleNode.get(outputExpressionId).asText();
                        if (StringUtils.isNotEmpty((CharSequence)outputExpressionValue) && outputExpressionValue.startsWith("\"") && outputExpressionValue.endsWith("\"")) {
                            outputExpressionValue = outputExpressionValue.substring(1, outputExpressionValue.length() - 1);
                        }
                        if (outputExpressionValue.startsWith("fn_date(")) {
                            outputExpressionValue = outputExpressionValue.substring(9, outputExpressionValue.lastIndexOf(39));
                        } else if (outputExpressionValue.startsWith("date:toDate(")) {
                            outputExpressionValue = outputExpressionValue.substring(13, outputExpressionValue.lastIndexOf(39));
                        }
                        newRuleNode.put(outputExpressionId, outputExpressionValue);
                    }
                    newRuleNodes.add((JsonNode)newRuleNode);
                }
                if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                    for (JsonNode inputExpressionNode : inputExpressionNodes) {
                        if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                        String inputId = inputExpressionNode.get("id").asText();
                        ((ObjectNode)inputExpressionNode).put("type", (String)inputExpressionIds.get(inputId));
                    }
                }
                ObjectNode decisionTableObjectNode = (ObjectNode)decisionTableNode;
                decisionTableObjectNode.replace("rules", (JsonNode)newRuleNodes);
            }
        }
        return decisionTableNode;
    }

    public static String determineExpressionType(String expressionValue) {
        String expressionType;
        block5: {
            expressionType = null;
            if (!"-".equals(expressionValue)) {
                expressionType = "string";
                if (NumberUtils.isNumber((String)expressionValue)) {
                    expressionType = "number";
                } else {
                    try {
                        new SimpleDateFormat("yyyy-MM-dd").parse(expressionValue);
                        expressionType = "date";
                    }
                    catch (ParseException pe) {
                        if (!"true".equalsIgnoreCase(expressionValue) && !"false".equalsIgnoreCase(expressionType)) break block5;
                        expressionType = "boolean";
                    }
                }
            }
        }
        return expressionType;
    }
}

