/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.dmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnJsonConverterUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnJsonConverterUtil.class);

    public static String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode jsonNode = objectNode.get(name);
        if (jsonNode != null && !jsonNode.isNull()) {
            propertyValue = jsonNode.asText();
        }
        return propertyValue;
    }

    public static JsonNode migrateModel(JsonNode decisionTableNode, ObjectMapper objectMapper) {
        if (decisionTableNode.get("modelVersion") == null || decisionTableNode.get("modelVersion").isNull()) {
            JsonNode inputExpressionNodes = decisionTableNode.get("inputExpressions");
            HashMap<Object, String> inputExpressionIds = new HashMap<Object, String>();
            if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                for (JsonNode inputExpressionNode : inputExpressionNodes) {
                    if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                    String inputId = inputExpressionNode.get("id").asText();
                    String inputType = null;
                    if (inputExpressionNode.get("type") != null && !inputExpressionNode.get("type").isNull()) {
                        inputType = inputExpressionNode.get("type").asText();
                    }
                    inputExpressionIds.put(inputId, inputType);
                }
            }
            JsonNode ruleNodes = decisionTableNode.get("rules");
            ArrayNode newRuleNodes = objectMapper.createArrayNode();
            if (ruleNodes != null && !ruleNodes.isNull()) {
                for (JsonNode ruleNode : ruleNodes) {
                    ObjectNode newRuleNode = objectMapper.createObjectNode();
                    for (String inputExpressionId : inputExpressionIds.keySet()) {
                        String oldExpression;
                        if (!ruleNode.has(inputExpressionId)) continue;
                        String operatorId = inputExpressionId + "_operator";
                        String expressionId = inputExpressionId + "_expression";
                        String operatorValue = null;
                        String expressionValue = null;
                        if (ruleNode.get(inputExpressionId) != null && !ruleNode.get(inputExpressionId).isNull() && StringUtils.isNotEmpty((CharSequence)(oldExpression = ruleNode.get(inputExpressionId).asText()))) {
                            if (oldExpression.indexOf(32) != -1) {
                                operatorValue = oldExpression.substring(0, oldExpression.indexOf(32));
                                expressionValue = oldExpression.substring(oldExpression.indexOf(32) + 1);
                            } else {
                                expressionValue = oldExpression;
                            }
                            if (expressionValue.startsWith("\"") && expressionValue.endsWith("\"")) {
                                expressionValue = expressionValue.substring(1, expressionValue.length() - 1);
                            }
                            if (expressionValue.startsWith("fn_date(")) {
                                expressionValue = expressionValue.substring(9, expressionValue.lastIndexOf(39));
                            } else if (expressionValue.startsWith("date:toDate(")) {
                                expressionValue = expressionValue.substring(13, expressionValue.lastIndexOf(39));
                            }
                            if (StringUtils.isEmpty((CharSequence)((CharSequence)inputExpressionIds.get(inputExpressionId)))) {
                                String expressionType = DmnJsonConverterUtil.determineExpressionType(expressionValue);
                                inputExpressionIds.put(inputExpressionId, expressionType);
                            }
                        }
                        if (StringUtils.isNotEmpty(operatorValue)) {
                            newRuleNode.put(operatorId, operatorValue);
                        } else {
                            newRuleNode.put(operatorId, "==");
                        }
                        if (StringUtils.isNotEmpty(expressionValue)) {
                            newRuleNode.put(expressionId, expressionValue);
                            continue;
                        }
                        newRuleNode.put(expressionId, "-");
                    }
                    Iterator ruleProperty = ruleNode.fieldNames();
                    while (ruleProperty.hasNext()) {
                        String outputExpressionId = (String)ruleProperty.next();
                        if (inputExpressionIds.containsKey(outputExpressionId)) continue;
                        String outputExpressionValue = ruleNode.get(outputExpressionId).asText();
                        if (StringUtils.isNotEmpty((CharSequence)outputExpressionValue) && outputExpressionValue.startsWith("\"") && outputExpressionValue.endsWith("\"")) {
                            outputExpressionValue = outputExpressionValue.substring(1, outputExpressionValue.length() - 1);
                        }
                        if (outputExpressionValue.startsWith("fn_date(")) {
                            outputExpressionValue = outputExpressionValue.substring(9, outputExpressionValue.lastIndexOf(39));
                        } else if (outputExpressionValue.startsWith("date:toDate(")) {
                            outputExpressionValue = outputExpressionValue.substring(13, outputExpressionValue.lastIndexOf(39));
                        }
                        newRuleNode.put(outputExpressionId, outputExpressionValue);
                    }
                    newRuleNodes.add((JsonNode)newRuleNode);
                }
                if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                    for (JsonNode inputExpressionNode : inputExpressionNodes) {
                        if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                        String inputId = inputExpressionNode.get("id").asText();
                        ((ObjectNode)inputExpressionNode).put("type", (String)inputExpressionIds.get(inputId));
                    }
                }
                ObjectNode decisionTableObjectNode = (ObjectNode)decisionTableNode;
                decisionTableObjectNode.replace("rules", (JsonNode)newRuleNodes);
            }
        }
        return decisionTableNode;
    }

    public static String determineExpressionType(String expressionValue) {
        String expressionType;
        block5: {
            expressionType = null;
            if (!"-".equals(expressionValue)) {
                expressionType = "string";
                if (NumberUtils.isCreatable((String)expressionValue)) {
                    expressionType = "number";
                } else {
                    try {
                        new SimpleDateFormat("yyyy-MM-dd").parse(expressionValue);
                        expressionType = "date";
                    }
                    catch (ParseException pe) {
                        if (!"true".equalsIgnoreCase(expressionValue) && !"false".equalsIgnoreCase(expressionType)) break block5;
                        expressionType = "boolean";
                    }
                }
            }
        }
        return expressionType;
    }

    public static String formatCollectionExpression(String containsOperator, String inputVariable, String expressionValue) {
        String containsPrefixAndMethod = DmnJsonConverterUtil.getDMNContainsExpressionMethod(containsOperator);
        StringBuilder stringBuilder = new StringBuilder();
        if (containsPrefixAndMethod != null) {
            stringBuilder.append("${");
            stringBuilder.append(containsPrefixAndMethod);
            stringBuilder.append("(");
            stringBuilder.append(DmnJsonConverterUtil.formatCollectionExpressionValue(inputVariable));
            stringBuilder.append(", ");
            String formattedExpressionValue = DmnJsonConverterUtil.formatCollectionExpressionValue(expressionValue);
            stringBuilder.append(formattedExpressionValue);
            stringBuilder.append(")}");
        } else {
            stringBuilder.append(containsOperator);
            stringBuilder.append(" ");
            stringBuilder.append(DmnJsonConverterUtil.formatCollectionExpressionValue(expressionValue));
        }
        return stringBuilder.toString();
    }

    public static boolean isCollectionOperator(String operator) {
        return "IN".equals(operator) || "NOT IN".equals(operator) || "ANY".equals(operator) || "NOT ANY".equals(operator);
    }

    protected static String getDMNContainsExpressionMethod(String containsOperator) {
        String containsPrefixAndMethod;
        if (StringUtils.isEmpty((CharSequence)containsOperator)) {
            throw new IllegalArgumentException("containsOperator must be provided");
        }
        switch (containsOperator) {
            case "IN": {
                containsPrefixAndMethod = "collection:contains";
                break;
            }
            case "NOT IN": {
                containsPrefixAndMethod = "collection:notContains";
                break;
            }
            case "ANY": {
                containsPrefixAndMethod = "collection:containsAny";
                break;
            }
            case "NOT ANY": {
                containsPrefixAndMethod = "collection:notContainsAny";
                break;
            }
            default: {
                containsPrefixAndMethod = null;
            }
        }
        return containsPrefixAndMethod;
    }

    protected static String formatCollectionExpressionValue(String expressionValue) {
        if (StringUtils.isEmpty((CharSequence)expressionValue)) {
            return "\"\"";
        }
        StringBuilder formattedExpressionValue = new StringBuilder();
        if (expressionValue.contains(",")) {
            formattedExpressionValue.append("'");
            List<String> formattedValues = DmnJsonConverterUtil.split(expressionValue);
            formattedExpressionValue.append(StringUtils.join(formattedValues, (char)','));
        } else {
            String formattedValue = expressionValue;
            formattedExpressionValue.append(formattedValue);
        }
        if (expressionValue.contains(",")) {
            formattedExpressionValue.append("'");
        }
        return formattedExpressionValue.toString();
    }

    protected static List<String> split(String str) {
        String regex = str.contains("\"") ? ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)" : ",";
        return Stream.of(str.split(regex)).map(elem -> elem.trim()).collect(Collectors.toList());
    }
}

