/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.bpmn.deployer.EventSubscriptionManager;
import org.flowable.engine.impl.bpmn.deployer.ParsedDeployment;
import org.flowable.engine.impl.bpmn.deployer.TimerManager;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;

public class BpmnDeploymentHelper {
    protected TimerManager timerManager;
    protected EventSubscriptionManager eventSubscriptionManager;

    public void verifyProcessDefinitionsDoNotShareKeys(Collection<ProcessDefinitionEntity> processDefinitions) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (keySet.contains(processDefinition.getKey())) {
                throw new FlowableException("The deployment contains process definitions with the same key (process id attribute), this is not allowed");
            }
            keySet.add(processDefinition.getKey());
        }
    }

    public void copyDeploymentValuesToProcessDefinitions(DeploymentEntity deployment, List<ProcessDefinitionEntity> processDefinitions) {
        String engineVersion = deployment.getEngineVersion();
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (engineVersion != null) {
                processDefinition.setEngineVersion(engineVersion);
            }
            if (tenantId != null) {
                processDefinition.setTenantId(tenantId);
            }
            processDefinition.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnProcessDefinitions(ParsedDeployment parsedDeployment) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            String resourceName = parsedDeployment.getResourceForProcessDefinition(processDefinition).getName();
            processDefinition.setResourceName(resourceName);
        }
    }

    public ProcessDefinitionEntity getMostRecentVersionOfProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String key = processDefinition.getKey();
        String tenantId = processDefinition.getTenantId();
        ProcessDefinitionEntityManager processDefinitionManager = Context.getCommandContext().getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity existingDefinition = null;
        existingDefinition = tenantId != null && !tenantId.equals("") ? processDefinitionManager.findLatestProcessDefinitionByKeyAndTenantId(key, tenantId) : processDefinitionManager.findLatestProcessDefinitionByKey(key);
        return existingDefinition;
    }

    public ProcessDefinitionEntity getPersistedInstanceOfProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String deploymentId = processDefinition.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)processDefinition.getDeploymentId())) {
            throw new IllegalStateException("Provided process definition must have a deployment id.");
        }
        ProcessDefinitionEntityManager processDefinitionManager = Context.getCommandContext().getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity persistedProcessDefinition = null;
        persistedProcessDefinition = processDefinition.getTenantId() == null || "".equals(processDefinition.getTenantId()) ? processDefinitionManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinition.getKey()) : processDefinitionManager.findProcessDefinitionByDeploymentAndKeyAndTenantId(deploymentId, processDefinition.getKey(), processDefinition.getTenantId());
        return persistedProcessDefinition;
    }

    public void updateTimersAndEvents(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity previousProcessDefinition, ParsedDeployment parsedDeployment) {
        Process process = parsedDeployment.getProcessModelForProcessDefinition(processDefinition);
        BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
        this.eventSubscriptionManager.removeObsoleteMessageEventSubscriptions(previousProcessDefinition);
        this.eventSubscriptionManager.addMessageEventSubscriptions(processDefinition, process, bpmnModel);
        this.eventSubscriptionManager.removeObsoleteSignalEventSubScription(previousProcessDefinition);
        this.eventSubscriptionManager.addSignalEventSubscriptions(Context.getCommandContext(), processDefinition, process, bpmnModel);
        this.timerManager.removeObsoleteTimers(processDefinition);
        this.timerManager.scheduleTimers(processDefinition, process);
    }

    public void addAuthorizationsForNewProcessDefinition(Process process, ProcessDefinitionEntity processDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        this.addAuthorizationsFromIterator(commandContext, process.getCandidateStarterUsers(), processDefinition, ExpressionType.USER);
        this.addAuthorizationsFromIterator(commandContext, process.getCandidateStarterGroups(), processDefinition, ExpressionType.GROUP);
    }

    protected void addAuthorizationsFromIterator(CommandContext commandContext, List<String> expressions, ProcessDefinitionEntity processDefinition, ExpressionType expressionType) {
        if (expressions != null) {
            for (String expression : expressions) {
                IdentityLinkEntity identityLink = (IdentityLinkEntity)commandContext.getIdentityLinkEntityManager().create();
                identityLink.setProcessDef(processDefinition);
                if (expressionType == ExpressionType.USER) {
                    identityLink.setUserId(expression);
                } else if (expressionType == ExpressionType.GROUP) {
                    identityLink.setGroupId(expression);
                }
                identityLink.setType("candidate");
                commandContext.getIdentityLinkEntityManager().insert(identityLink);
            }
        }
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    public EventSubscriptionManager getEventSubscriptionManager() {
        return this.eventSubscriptionManager;
    }

    public void setEventSubscriptionManager(EventSubscriptionManager eventSubscriptionManager) {
        this.eventSubscriptionManager = eventSubscriptionManager;
    }

    static enum ExpressionType {
        USER,
        GROUP;

    }
}

